/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.root;

import com.dooapp.gaedo.finders.FieldInformer;
import com.dooapp.gaedo.finders.root.FieldInformerLocator;
import com.dooapp.gaedo.finders.root.NoLocatorAllowsFieldException;
import com.dooapp.gaedo.properties.Property;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class CumulativeFieldInformerLocator
implements FieldInformerLocator {
    private Collection<FieldInformerLocator> locators = new LinkedList<FieldInformerLocator>();

    public boolean add(FieldInformerLocator e) {
        return this.locators.add(e);
    }

    @Override
    public FieldInformer getInformerFor(Property field) {
        FieldInformer returned = null;
        LinkedHashMap<FieldInformerLocator, Exception> thrownDuringSearch = new LinkedHashMap<FieldInformerLocator, Exception>();
        for (FieldInformerLocator locator : this.locators) {
            try {
                returned = locator.getInformerFor(field);
                if (returned == null) continue;
                return returned;
            }
            catch (Exception e) {
                thrownDuringSearch.put(locator, e);
            }
        }
        throw new NoLocatorAllowsFieldException(field, thrownDuringSearch);
    }

    @Override
    public FieldInformer getInformerFor(Class informedClass, String fieldName) {
        FieldInformer returned = null;
        LinkedHashMap<FieldInformerLocator, Exception> thrownDuringSearch = new LinkedHashMap<FieldInformerLocator, Exception>();
        for (FieldInformerLocator locator : this.locators) {
            try {
                returned = locator.getInformerFor(informedClass, fieldName);
                if (returned == null) continue;
                return returned;
            }
            catch (Exception e) {
                thrownDuringSearch.put(locator, e);
            }
        }
        throw new NoLocatorAllowsFieldException(informedClass, fieldName, thrownDuringSearch);
    }
}

