/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.root;

import com.dooapp.gaedo.finders.FieldInformer;
import com.dooapp.gaedo.finders.informers.BooleanFieldInformer;
import com.dooapp.gaedo.finders.informers.ClassFieldInformer;
import com.dooapp.gaedo.finders.informers.CollectionFieldInformer;
import com.dooapp.gaedo.finders.informers.DateFieldInformer;
import com.dooapp.gaedo.finders.informers.DoubleFieldInformer;
import com.dooapp.gaedo.finders.informers.EnumFieldInformer;
import com.dooapp.gaedo.finders.informers.MapFieldInformer;
import com.dooapp.gaedo.finders.informers.ObjectFieldInformer;
import com.dooapp.gaedo.finders.informers.StringFieldInformer;
import com.dooapp.gaedo.finders.root.ConflictingInformersForThisTypeException;
import com.dooapp.gaedo.finders.root.FieldInformerLocator;
import com.dooapp.gaedo.finders.root.NoInformerForThisTypeException;
import com.dooapp.gaedo.finders.root.UnableToCreateFieldInformerException;
import com.dooapp.gaedo.properties.Property;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;

public class BasicFieldInformerLocator
implements FieldInformerLocator {
    private Map<Class<?>, Class<? extends FieldInformer>> existingInformerMappings = BasicFieldInformerLocator.getInformersMapping();

    @Override
    public FieldInformer getInformerFor(Property field) {
        Type genericType = field.getGenericType();
        return this.getInformerFor(field, genericType);
    }

    protected FieldInformer getInformerFor(Property property, Type genericType) {
        if (genericType instanceof Class) {
            Class clazz = (Class)genericType;
            Class<? extends FieldInformer> informerClass = this.getInformerForClass(clazz);
            try {
                Constructor<? extends FieldInformer> used = informerClass.getDeclaredConstructor(Property.class);
                return used.newInstance(property);
            }
            catch (Exception e) {
                throw new UnableToCreateFieldInformerException(clazz, informerClass, property.getClass(), e);
            }
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericType;
            return this.getInformerFor(property, pType.getRawType());
        }
        return null;
    }

    protected Class<? extends FieldInformer> getInformerForClass(Class<?> clazz) {
        Class<? extends FieldInformer> existingOne = this.hierarchicalySearchForInformer(clazz);
        if (existingOne == null) {
            throw new NoInformerForThisTypeException(clazz);
        }
        return existingOne;
    }

    private Class<? extends FieldInformer> hierarchicalySearchForInformer(Class<?> clazz) {
        Object existingOne = null;
        if (this.existingInformerMappings.containsKey(clazz)) {
            return this.existingInformerMappings.get(clazz);
        }
        HashMap foundInformers = new HashMap();
        for (Class<?> interfazz : clazz.getInterfaces()) {
            if (!this.existingInformerMappings.containsKey(clazz)) continue;
            foundInformers.put(interfazz, this.existingInformerMappings.get(clazz));
        }
        if (foundInformers.size() == 1) {
            return (Class)foundInformers.entrySet().iterator().next().getValue();
        }
        if (foundInformers.size() > 1) {
            throw new ConflictingInformersForThisTypeException(clazz, foundInformers);
        }
        if (Object.class.equals(clazz)) {
            return null;
        }
        if (clazz.getSuperclass() != null) {
            return this.hierarchicalySearchForInformer(clazz.getSuperclass());
        }
        return null;
    }

    public static Map<Class<?>, Class<? extends FieldInformer>> getInformersMapping() {
        HashMap returned = new HashMap();
        returned.put(String.class, StringFieldInformer.class);
        returned.put(Boolean.class, BooleanFieldInformer.class);
        returned.put(Boolean.TYPE, BooleanFieldInformer.class);
        returned.put(Number.class, DoubleFieldInformer.class);
        returned.put(Byte.TYPE, DoubleFieldInformer.class);
        returned.put(Short.TYPE, DoubleFieldInformer.class);
        returned.put(Integer.TYPE, DoubleFieldInformer.class);
        returned.put(Long.TYPE, DoubleFieldInformer.class);
        returned.put(Float.TYPE, DoubleFieldInformer.class);
        returned.put(Double.TYPE, DoubleFieldInformer.class);
        returned.put(Character.TYPE, DoubleFieldInformer.class);
        returned.put(Byte.class, DoubleFieldInformer.class);
        returned.put(Short.class, DoubleFieldInformer.class);
        returned.put(Integer.class, DoubleFieldInformer.class);
        returned.put(Long.class, DoubleFieldInformer.class);
        returned.put(Float.class, DoubleFieldInformer.class);
        returned.put(Double.class, DoubleFieldInformer.class);
        returned.put(Character.class, DoubleFieldInformer.class);
        returned.put(Date.class, DateFieldInformer.class);
        returned.put(Collection.class, CollectionFieldInformer.class);
        returned.put(List.class, CollectionFieldInformer.class);
        returned.put(Set.class, CollectionFieldInformer.class);
        returned.put(SortedSet.class, CollectionFieldInformer.class);
        returned.put(Map.class, MapFieldInformer.class);
        returned.put(SortedMap.class, MapFieldInformer.class);
        returned.put(ConcurrentMap.class, MapFieldInformer.class);
        returned.put(ConcurrentNavigableMap.class, MapFieldInformer.class);
        returned.put(PropertyChangeSupport.class, ObjectFieldInformer.class);
        returned.put(Class.class, ClassFieldInformer.class);
        returned.put(Enum.class, EnumFieldInformer.class);
        returned.put(Serializable.class, ObjectFieldInformer.class);
        return returned;
    }

    @Override
    public FieldInformer getInformerFor(Class informedClass, String fieldName) {
        return null;
    }
}

