/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.root;

import com.dooapp.gaedo.finders.Informer;
import com.dooapp.gaedo.finders.QueryBuilder;
import com.dooapp.gaedo.finders.QueryExpression;
import com.dooapp.gaedo.finders.QueryExpressionContainerVisitor;
import com.dooapp.gaedo.finders.QueryStatement;
import com.dooapp.gaedo.finders.SortingBuilder;
import com.dooapp.gaedo.finders.SortingExpression;
import com.dooapp.gaedo.finders.sort.SortingExpressionImpl;
import com.dooapp.gaedo.utils.PropertyChangeEmitter;
import java.beans.PropertyChangeEvent;

public abstract class AbstractQueryStatement<DataType, InformerType extends Informer<DataType>>
implements QueryStatement<DataType, InformerType> {
    private QueryStatement.State state = QueryStatement.State.INITIAL;
    protected final QueryBuilder<InformerType> query;
    private InformerType informer;
    private SortingExpression sortingExpression = new SortingExpressionImpl();
    private QueryExpression queryExpression;
    private PropertyChangeEmitter emitter;
    private String id;

    public AbstractQueryStatement(QueryBuilder<InformerType> query, InformerType informer, PropertyChangeEmitter emitter) {
        this.query = query;
        this.informer = informer;
        this.emitter = emitter;
    }

    protected QueryExpression buildQueryExpression() {
        if (this.queryExpression == null) {
            this.queryExpression = this.query.createMatchingExpression(this.informer);
            this.setState(QueryStatement.State.MATCHING);
        }
        return this.queryExpression;
    }

    @Override
    public QueryStatement<DataType, InformerType> sortBy(SortingBuilder<InformerType> expression) {
        this.sortingExpression = expression.createSortingExpression(this.informer);
        this.setState(QueryStatement.State.SORTING);
        return this;
    }

    protected SortingExpression getSortingExpression() {
        return this.sortingExpression;
    }

    @Override
    public void accept(QueryExpressionContainerVisitor visitor) {
        visitor.startVisit(this);
        this.buildQueryExpression().accept(visitor);
        this.sortingExpression.accept(visitor);
        visitor.endVisit(this);
    }

    @Override
    public QueryStatement.State getState() {
        return this.state;
    }

    public void setState(QueryStatement.State state) {
        if (this.state != state) {
            QueryStatement.State old = this.state;
            this.state = state;
            this.emitter.firePropertyChange(new PropertyChangeEvent(this, "state", (Object)old, (Object)state));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

