/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.root;

import com.dooapp.gaedo.finders.Finder;
import com.dooapp.gaedo.finders.FinderCrudService;
import com.dooapp.gaedo.finders.Informer;
import com.dooapp.gaedo.finders.QueryBuilder;
import com.dooapp.gaedo.finders.QueryStatement;
import com.dooapp.gaedo.finders.root.InformerFactory;
import com.dooapp.gaedo.finders.root.SimpleFinder;

public abstract class AbstractFinderService<DataType, InformerType extends Informer<DataType>>
implements FinderCrudService<DataType, InformerType> {
    protected final Class<DataType> containedClass;
    protected final Class<InformerType> informerClass;
    private InformerFactory informerFactory;

    public AbstractFinderService(Class<DataType> containedClass, Class<InformerType> informerClass, InformerFactory factory) {
        this.containedClass = containedClass;
        this.informerClass = informerClass;
        this.informerFactory = factory;
    }

    protected abstract QueryStatement<DataType, InformerType> createQueryStatement(QueryBuilder<InformerType> var1);

    @Override
    public Finder<DataType, InformerType> find() {
        return new SimpleFinder(this);
    }

    @Override
    public InformerType getInformer() {
        return this.informerFactory.get(this.informerClass, this.containedClass);
    }

    @Override
    public Class<DataType> getContainedClass() {
        return this.containedClass;
    }

    public String toString() {
        StringBuilder sOut = new StringBuilder();
        sOut.append(this.getClass().getName());
        sOut.append("(containdClass:").append(this.getContainedClass().getName());
        sOut.append("; informerClass:").append(this.getInformer().toString()).append(")");
        return sOut.toString();
    }

    protected InformerFactory getInformerFactory() {
        return this.informerFactory;
    }

    protected void setInformerFactory(InformerFactory informerFactory) {
        this.informerFactory = informerFactory;
    }
}

