/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.informers;

import com.dooapp.gaedo.finders.FieldInformer;
import com.dooapp.gaedo.finders.FieldInformerAPI;
import com.dooapp.gaedo.finders.QueryExpression;
import com.dooapp.gaedo.finders.expressions.AnythingExpression;
import com.dooapp.gaedo.finders.expressions.EqualsExpression;
import com.dooapp.gaedo.finders.expressions.Expressions;
import com.dooapp.gaedo.properties.Property;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class ObjectFieldInformer
implements FieldInformerAPI {
    protected final Property source;
    protected Collection<Property> parentPath = Collections.emptyList();

    public ObjectFieldInformer(Property source) {
        this.source = source;
    }

    @Override
    public QueryExpression equalsTo(Object value) {
        return new EqualsExpression(this.source, this.getFieldPath(), value);
    }

    public QueryExpression differentFrom(Object value) {
        return Expressions.not(this.equalsTo(value));
    }

    public QueryExpression isAnything() {
        return new AnythingExpression(this.source, this.getFieldPath());
    }

    public String toString() {
        StringBuilder sOut = new StringBuilder();
        sOut.append(this.getClass().getName()).append(" on field ").append(this.source.toGenericString());
        return sOut.toString();
    }

    @Override
    public Property getField() {
        return this.source;
    }

    protected ObjectFieldInformer clone() {
        return new ObjectFieldInformer(this.source);
    }

    @Override
    public Iterable<Property> getFieldPath() {
        LinkedList<Property> returned = new LinkedList<Property>(this.parentPath);
        returned.add(this.source);
        return returned;
    }

    @Override
    public FieldInformer with(Collection<Property> propertyPath) {
        ObjectFieldInformer returned = this.clone();
        returned.parentPath = propertyPath;
        return returned;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectFieldInformer other = (ObjectFieldInformer)obj;
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }
}

