/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.id;

import com.dooapp.gaedo.extensions.hierarchy.Child;
import com.dooapp.gaedo.extensions.hierarchy.Parent;
import com.dooapp.gaedo.finders.id.Id;
import com.dooapp.gaedo.properties.Property;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AnnotationsFinder {
    public static List<Property> findAll(Property[] fields, Annotations toSupport) {
        LinkedList<Property> returned = new LinkedList<Property>();
        for (Property f : fields) {
            Collection<? extends Annotation> annotations;
            if (f.hasModifier(8) || !toSupport.hasAny(annotations = f.getAnnotations())) continue;
            returned.add(f);
            break;
        }
        return returned;
    }

    public static enum Annotations {
        ID(Arrays.asList("javax.persistence.Id", Id.class.getCanonicalName())),
        TRANSIENT(Arrays.asList("javax.persistence.Transient")),
        PARENT(Arrays.asList(Parent.class.getCanonicalName())),
        CHILD(Arrays.asList(Child.class.getCanonicalName()));

        private Collection<String> annotationsNames;

        private Annotations(Collection<String> names) {
            this.annotationsNames = Collections.unmodifiableCollection(names);
        }

        public boolean hasAny(Collection<? extends Annotation> annotations) {
            for (Annotation annotation : annotations) {
                if (!this.annotationsNames.contains(annotation.annotationType().getName())) continue;
                return true;
            }
            return false;
        }

        public boolean is(Property p) {
            return this.hasAny(p.getAnnotations());
        }
    }
}

