/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.id;

import com.dooapp.gaedo.finders.id.AnnotationsFinder;
import com.dooapp.gaedo.finders.id.BadIdAnnotatedClassException;
import com.dooapp.gaedo.properties.Property;
import com.dooapp.gaedo.properties.PropertyProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AnnotationUtils {
    public static Property locateOneField(AnnotationsFinder.Annotations annotation, PropertyProvider provider, Class<?> containedClass, Collection<Class> expectedIdClasses) {
        return AnnotationUtils.locateOneField(AnnotationsFinder.Annotations.ID, provider, containedClass, containedClass, expectedIdClasses);
    }

    private static Property locateOneField(AnnotationsFinder.Annotations annotation, PropertyProvider provider, Class<?> inputClass, Class<?> currentClass, Collection<Class> expectedIdClasses) {
        Property[] fields = provider.get(currentClass);
        List<Property> probableId = AnnotationsFinder.findAll(fields, AnnotationsFinder.Annotations.ID);
        Property idField = null;
        if (probableId.size() == 1) {
            Property potentialIdField = probableId.get(0);
            if (expectedIdClasses != null) {
                boolean found = false;
                Iterator<Class> iterator = expectedIdClasses.iterator();
                while (iterator.hasNext() && !found) {
                    found = potentialIdField.getType().isAssignableFrom(iterator.next());
                }
                if (found) {
                    idField = potentialIdField;
                }
            }
        }
        if (idField == null) {
            Class<?> nextClass = currentClass.getSuperclass();
            if (Object.class.equals(nextClass)) {
                throw new BadIdAnnotatedClassException(inputClass, expectedIdClasses);
            }
            idField = AnnotationUtils.locateOneField(annotation, provider, inputClass, nextClass, expectedIdClasses);
        }
        return idField;
    }

    public static Property locateIdField(PropertyProvider provider, Class<?> containedClass, Class ... idClasses) {
        return AnnotationUtils.locateOneField(AnnotationsFinder.Annotations.ID, provider, containedClass, Arrays.asList(idClasses));
    }

    public static List<Property> locateAllFields(PropertyProvider provider, Class<?> containedClass, AnnotationsFinder.Annotations id) {
        return AnnotationUtils.locateAllFields(provider, containedClass, containedClass, id);
    }

    private static List<Property> locateAllFields(PropertyProvider provider, Class<?> containedClass, Class<?> currentClass, AnnotationsFinder.Annotations id) {
        if (!Object.class.equals(currentClass)) {
            Property[] fields = provider.get(currentClass);
            List<Property> returned = AnnotationsFinder.findAll(fields, id);
            returned.addAll(AnnotationUtils.locateAllFields(provider, containedClass, currentClass.getSuperclass(), id));
            return returned;
        }
        return Collections.emptyList();
    }
}

