/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.expressions;

import com.dooapp.gaedo.finders.expressions.AbstractBasicExpression;
import com.dooapp.gaedo.finders.expressions.AndQueryExpression;
import com.dooapp.gaedo.finders.expressions.AnythingExpression;
import com.dooapp.gaedo.finders.expressions.CollectionContaingExpression;
import com.dooapp.gaedo.finders.expressions.ContainsStringExpression;
import com.dooapp.gaedo.finders.expressions.EndsWithExpression;
import com.dooapp.gaedo.finders.expressions.EqualsExpression;
import com.dooapp.gaedo.finders.expressions.GreaterThanExpression;
import com.dooapp.gaedo.finders.expressions.LowerThanExpression;
import com.dooapp.gaedo.finders.expressions.MapContainingKeyExpression;
import com.dooapp.gaedo.finders.expressions.NotQueryExpression;
import com.dooapp.gaedo.finders.expressions.OrQueryExpression;
import com.dooapp.gaedo.finders.expressions.QueryExpressionVisitor;
import com.dooapp.gaedo.finders.expressions.StartsWithExpression;
import com.dooapp.gaedo.finders.informers.MapContainingValueExpression;
import com.dooapp.gaedo.properties.Property;

public class ToStringVisitor
implements QueryExpressionVisitor {
    private String indent = "\t";
    private int deepness = 0;
    private StringBuilder out = new StringBuilder();

    private StringBuilder deepnessString() {
        StringBuilder sOut = new StringBuilder();
        for (int i = 0; i < this.deepness; ++i) {
            sOut.append(this.indent);
        }
        return sOut;
    }

    @Override
    public void endVisit(OrQueryExpression orQueryExpression) {
        --this.deepness;
    }

    @Override
    public void endVisit(AndQueryExpression andQueryExpression) {
        --this.deepness;
    }

    @Override
    public void endVisit(NotQueryExpression notQueryExpression) {
        --this.deepness;
    }

    @Override
    public void startVisit(OrQueryExpression orQueryExpression) {
        this.out.append((CharSequence)this.deepnessString()).append("OR").append("\n");
        ++this.deepness;
    }

    @Override
    public void startVisit(AndQueryExpression andQueryExpression) {
        this.out.append((CharSequence)this.deepnessString()).append("AND").append("\n");
        ++this.deepness;
    }

    @Override
    public void startVisit(NotQueryExpression notQueryExpression) {
        this.out.append((CharSequence)this.deepnessString()).append("NOT").append("\n");
        ++this.deepness;
    }

    @Override
    public void visit(AnythingExpression expression) {
        this.out.append((CharSequence)this.deepnessString()).append(this.getFieldText(expression)).append("\tis anything (yep, really anything)").append("\n");
    }

    @Override
    public void visit(EqualsExpression expression) {
        this.out.append((CharSequence)this.deepnessString()).append(this.getFieldText(expression)).append("\t==?\t").append(expression.getValue().toString()).append("\n");
    }

    private String getFieldText(AbstractBasicExpression expression) {
        Property f = expression.getField();
        if (f == null) {
            return "this";
        }
        return f.toGenericString();
    }

    public String toString() {
        return this.out.toString();
    }

    @Override
    public <ComparableType extends Comparable<ComparableType>> void visit(GreaterThanExpression<ComparableType> greaterThanExpression) {
        this.out.append((CharSequence)this.deepnessString()).append(this.getFieldText(greaterThanExpression)).append(">").append(greaterThanExpression.isStrictly() ? "" : "=").append("?").append(greaterThanExpression.getValue().toString()).append("\n");
    }

    @Override
    public <ComparableType extends Comparable<ComparableType>> void visit(LowerThanExpression<ComparableType> lowerThanExpression) {
        this.out.append((CharSequence)this.deepnessString()).append(this.getFieldText(lowerThanExpression)).append("<").append(lowerThanExpression.isStrictly() ? "" : "=").append("?").append(lowerThanExpression.getValue().toString()).append("\n");
    }

    @Override
    public void visit(ContainsStringExpression expression) {
        this.out.append((CharSequence)this.deepnessString()).append(this.getFieldText(expression)).append(" contains? ").append(expression.getContained()).append("\n");
    }

    @Override
    public void visit(StartsWithExpression expression) {
        this.out.append((CharSequence)this.deepnessString()).append(this.getFieldText(expression)).append(" startsWith? ").append(expression.getStart()).append("\n");
    }

    @Override
    public void visit(EndsWithExpression expression) {
        this.out.append((CharSequence)this.deepnessString()).append(this.getFieldText(expression)).append(" endsWith? ").append(expression.getEnd()).append("\n");
    }

    @Override
    public void visit(CollectionContaingExpression expression) {
        this.out.append((CharSequence)this.deepnessString()).append(this.getFieldText(expression)).append(" contains? ").append(expression.getContained().toString()).append("\n");
    }

    @Override
    public void visit(MapContainingValueExpression expression) {
        this.out.append((CharSequence)this.deepnessString()).append(this.getFieldText(expression)).append(" containsKey? ").append(expression.getContained().toString()).append("\n");
    }

    @Override
    public void visit(MapContainingKeyExpression expression) {
        this.out.append((CharSequence)this.deepnessString()).append(this.getFieldText(expression)).append(" containsValue? ").append(expression.getContained().toString()).append("\n");
    }
}

