/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.expressions;

import com.dooapp.gaedo.finders.QueryExpression;
import com.dooapp.gaedo.finders.expressions.QueryExpressionVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;

public abstract class AggregatingQueryExpression
implements QueryExpression {
    protected Collection<QueryExpression> expressions = new LinkedList<QueryExpression>();

    public AggregatingQueryExpression(QueryExpression ... expressions) {
        this.expressions.addAll(Arrays.asList(expressions));
    }

    public AggregatingQueryExpression(Collection<QueryExpression> expressions) {
        this(new QueryExpression[0]);
        this.add(expressions.toArray(new QueryExpression[expressions.size()]));
    }

    public void add(QueryExpression ... toAdd) {
        this.expressions.addAll(Arrays.asList(toAdd));
    }

    @Override
    public void accept(QueryExpressionVisitor visitor) {
        this.startVisitFor(visitor);
        for (QueryExpression exp : this.expressions) {
            exp.accept(visitor);
        }
        this.endVisitFor(visitor);
    }

    protected abstract void endVisitFor(QueryExpressionVisitor var1);

    protected abstract void startVisitFor(QueryExpressionVisitor var1);
}

