/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.dynamic;

import com.dooapp.gaedo.finders.FinderCrudService;
import com.dooapp.gaedo.finders.Informer;
import com.dooapp.gaedo.finders.dynamic.DynamicFinder;
import com.dooapp.gaedo.finders.dynamic.DynamicFinderHandler;
import com.dooapp.gaedo.finders.dynamic.ServiceGenerator;
import com.dooapp.gaedo.properties.PropertyProvider;
import com.dooapp.gaedo.utils.UnableToCreateInvocationHandlerException;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServiceGeneratorImpl
implements ServiceGenerator {
    private static final Logger logger = Logger.getLogger(ServiceGeneratorImpl.class.getName());
    protected final PropertyProvider provider;

    public ServiceGeneratorImpl(PropertyProvider provider) {
        this.provider = provider;
    }

    @Override
    public <DataType, InformerType extends Informer<DataType>, Implementation extends DynamicFinder<DataType, InformerType>> Implementation generate(Class<Implementation> toImplement, FinderCrudService<DataType, InformerType> backEnd) {
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("creating a DynamicFinderHandler mapping " + toImplement.getName() + " to " + backEnd.getClass().getName());
        }
        try {
            DynamicFinder proxy = (DynamicFinder)Proxy.newProxyInstance(toImplement.getClassLoader(), new Class[]{toImplement}, new DynamicFinderHandler<Implementation>(toImplement, backEnd, this.provider));
            return (Implementation)proxy;
        }
        catch (UnableToCreateInvocationHandlerException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Unable to create implementation of " + toImplement.getCanonicalName() + " " + "using as back-end " + backEnd.getClass().getCanonicalName() + "<" + backEnd.getContainedClass().getCanonicalName() + ", " + backEnd.getInformer().getClass().getCanonicalName() + ">");
            }
            throw e;
        }
    }
}

