/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.dynamic;

import com.dooapp.gaedo.exceptions.finder.dynamic.MethodBindingException;
import com.dooapp.gaedo.finders.FinderCrudService;
import com.dooapp.gaedo.finders.Informer;
import com.dooapp.gaedo.finders.QueryBuilder;
import com.dooapp.gaedo.finders.QueryExpression;
import com.dooapp.gaedo.finders.QueryStatement;
import com.dooapp.gaedo.finders.SortingBuilder;
import com.dooapp.gaedo.finders.SortingExpression;
import com.dooapp.gaedo.finders.dynamic.DynamicFinderMethodResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;

public enum Mode {
    COUNT("countBy", 0),
    FIND_ALL("findAllBy", 0),
    FIND_RANGE("findRangeBy", 2),
    FIND_ONE("findOneWith", 0);

    private final String prefix;
    private final int offset;

    private Mode(String prefix, int offset) {
        this.prefix = prefix;
        this.offset = offset;
    }

    public Object execute(FinderCrudService backEnd, QueryExpression expression, SortingExpression sortingExpression, Object[] parameters, String id) {
        QueryStatement queryStatement = this.buildQueryStatement(backEnd, expression, sortingExpression);
        return this.execute(queryStatement, parameters, id);
    }

    public Object execute(QueryStatement queryStatement, Object[] parameters, String id) {
        queryStatement.setId(id);
        switch (this) {
            case COUNT: {
                return queryStatement.count();
            }
            case FIND_ALL: {
                return queryStatement.getAll();
            }
            case FIND_ONE: {
                return queryStatement.getFirst();
            }
            case FIND_RANGE: {
                return queryStatement.get((Integer)parameters[0], (Integer)parameters[1]);
            }
        }
        throw new UnsupportedOperationException("mode entered is not one of Mode values ??? How is it possible ? please fill a bug report at gaedo-definition");
    }

    private QueryStatement buildQueryStatement(FinderCrudService backEnd, final QueryExpression expression, final SortingExpression sortingExpression) {
        QueryStatement queryStatement = backEnd.find().matching(new QueryBuilder<Informer<?>>(){

            @Override
            public QueryExpression createMatchingExpression(Informer<?> object) {
                return expression;
            }
        }).sortBy(new SortingBuilder<Informer<?>>(){

            @Override
            public SortingExpression createSortingExpression(Informer<?> informer) {
                return sortingExpression;
            }
        });
        return queryStatement;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.getPrefix();
    }

    public int getOffset() {
        return this.offset;
    }

    public void checkParametersClasses(Method method, Type[] modeArgs, DynamicFinderMethodResolver resolver) {
        switch (this) {
            case COUNT: {
                return;
            }
            case FIND_ALL: {
                return;
            }
            case FIND_ONE: {
                return;
            }
            case FIND_RANGE: {
                for (Type t : modeArgs) {
                    if (Integer.class.equals((Object)t) || Integer.TYPE.equals(t)) continue;
                    throw new MethodBindingException(method, resolver, Arrays.asList(this.prefix + " methods require the first two parameters to be int or integer, which is not the case here"));
                }
                return;
            }
        }
        throw new UnsupportedOperationException("mode entered is not one of Mode values ??? How is it possible ? please fill a bug report at gaedo-definition");
    }
}

