/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.dynamic;

import com.dooapp.gaedo.exceptions.finder.dynamic.MethodBindingException;
import com.dooapp.gaedo.exceptions.finder.dynamic.UnableToBuildQueryExpressionException;
import com.dooapp.gaedo.finders.FieldInformer;
import com.dooapp.gaedo.finders.FinderCrudService;
import com.dooapp.gaedo.finders.QueryExpression;
import com.dooapp.gaedo.finders.QueryExpressionContainer;
import com.dooapp.gaedo.finders.QueryExpressionContainerVisitor;
import com.dooapp.gaedo.finders.SortingExpression;
import com.dooapp.gaedo.finders.dynamic.BadReturnTypeException;
import com.dooapp.gaedo.finders.dynamic.Combinator;
import com.dooapp.gaedo.finders.dynamic.Mode;
import com.dooapp.gaedo.finders.sort.SortingExpressionImpl;
import com.dooapp.gaedo.utils.Entry;
import com.dooapp.gaedo.utils.MethodResolver;
import com.dooapp.gaedo.utils.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

public class DynamicFinderMethodResolver
implements QueryExpressionContainer,
MethodResolver {
    private Combinator combinator = Combinator.And;
    private Collection<Map.Entry<FieldInformer, Method>> queryExpressions = new LinkedList<Map.Entry<FieldInformer, Method>>();
    private Mode mode;
    private FinderCrudService backEnd;
    private final String executionId;
    private Class<?> returnType;
    private SortingExpression sortingExpression = new SortingExpressionImpl();

    public DynamicFinderMethodResolver(FinderCrudService backEnd, Method method) {
        this(backEnd, method.toGenericString(), method.getReturnType());
    }

    public DynamicFinderMethodResolver(FinderCrudService backEnd, String executionId, Class<?> returnType) {
        this.backEnd = backEnd;
        this.executionId = executionId;
        this.returnType = returnType;
    }

    public void addQueryExpression(FieldInformer informer, Method method) {
        this.queryExpressions.add(new Entry<FieldInformer, Method>(informer, method));
    }

    public void addSortingExpression(FieldInformer informer, SortingExpression.Direction direction) {
        this.sortingExpression.add(informer, direction);
    }

    @Override
    public Object call(Object[] args) {
        LinkedList<QueryExpression> resolvedExpressions = new LinkedList<QueryExpression>();
        int offset = this.mode.getOffset();
        for (Map.Entry<FieldInformer, Method> entry : this.queryExpressions) {
            int consumableLength = entry.getValue().getParameterTypes().length;
            Object[] methodArgs = new Object[consumableLength];
            System.arraycopy(args, offset, methodArgs, 0, consumableLength);
            offset += consumableLength;
            try {
                resolvedExpressions.add((QueryExpression)entry.getValue().invoke((Object)entry.getKey(), methodArgs));
            }
            catch (Exception e) {
                throw new UnableToBuildQueryExpressionException(entry.getKey(), entry.getValue(), methodArgs, e);
            }
        }
        QueryExpression queryExpression = this.combinator.create(resolvedExpressions);
        Object[] modeArgs = new Object[this.mode.getOffset()];
        System.arraycopy(args, 0, modeArgs, 0, this.mode.getOffset());
        Collection returned = this.mode.execute(this.backEnd, queryExpression, this.sortingExpression, modeArgs, this.executionId);
        if (!(this.mode != Mode.FIND_ALL && this.mode != Mode.FIND_RANGE || Iterable.class.equals(this.returnType))) {
            Collection toReturn = Utils.generateCollection(this.returnType, null);
            Iterable iterable = returned;
            for (Object data : iterable) {
                toReturn.add(data);
            }
            returned = toReturn;
        }
        return returned;
    }

    public void checkParametersClasses(Method method) {
        LinkedList<String> errors = new LinkedList<String>();
        Type[] consumableParameters = method.getGenericParameterTypes();
        LinkedList<Type> consumableList = new LinkedList<Type>(Arrays.asList(consumableParameters));
        Type[] modeArgs = new Type[this.mode.getOffset()];
        System.arraycopy(consumableParameters, 0, modeArgs, 0, this.mode.getOffset());
        this.mode.checkParametersClasses(method, modeArgs, this);
        int paramIndex = this.mode.getOffset();
        for (Map.Entry<FieldInformer, Method> entry : this.queryExpressions) {
            Class<?>[] parameters;
            for (Class<?> p : parameters = entry.getValue().getParameterTypes()) {
                if (consumableList.size() == 0) {
                    errors.add("there are not enough parameters to match method call " + entry.getKey().toString() + " " + entry.getValue().toGenericString());
                    continue;
                }
                Type toCompare = (Type)consumableList.remove(0);
                if (toCompare instanceof Class) {
                    Class<?> toCompareClass = (Class<?>)toCompare;
                    if (toCompareClass.isPrimitive()) {
                        toCompareClass = Utils.objectify(toCompareClass);
                    }
                    if (p.isAssignableFrom(toCompareClass)) continue;
                    errors.add("parameter " + p.getName() + " of method " + entry.getValue().toGenericString() + "cannot use value of type " + toCompareClass.getName());
                    continue;
                }
                throw new UnsupportedOperationException(toCompare.getClass().getName() + " not supported in that case. please fill a gaedo-definition bug report");
            }
            ++paramIndex;
        }
        if (errors.size() > 0) {
            throw new MethodBindingException(method, this, errors);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setCombinator(Combinator c) {
        this.combinator = c;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String toString() {
        StringBuilder sOut = new StringBuilder();
        sOut.append("combination : ").append((Object)this.combinator).append("\n");
        sOut.append("expression :\n");
        for (Map.Entry<FieldInformer, Method> entry : this.queryExpressions) {
            sOut.append("\t").append(entry.getKey().toString()).append("\tinvoking\t").append(entry.getValue().toGenericString()).append("\n");
        }
        return sOut.toString();
    }

    public void checkMethod(Method method) {
        this.checkParametersClasses(method);
        this.checkReturnType(method);
    }

    private void checkReturnType(Method method) {
        Class returnType = method.getReturnType();
        switch (this.mode) {
            case COUNT: {
                if (Integer.class.isAssignableFrom(returnType) || Integer.TYPE.isAssignableFrom(returnType) || Long.class.isAssignableFrom(returnType) || Long.TYPE.isAssignableFrom(returnType)) break;
                throw new BadReturnTypeException(method, returnType, Integer.class, Integer.TYPE, Long.TYPE, Long.class);
            }
            case FIND_ALL: {
                if (Iterable.class.isAssignableFrom(returnType)) break;
                throw new BadReturnTypeException(method, returnType, Iterable.class);
            }
            case FIND_ONE: {
                if (returnType.isAssignableFrom(this.backEnd.getContainedClass())) break;
                throw new BadReturnTypeException(method, returnType, this.backEnd.getContainedClass());
            }
        }
    }

    @Override
    public void accept(QueryExpressionContainerVisitor visitor) {
        visitor.startVisit(this);
        this.sortingExpression.accept(visitor);
        visitor.endVisit(this);
    }
}

