/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.dynamic;

import com.dooapp.gaedo.exceptions.finder.dynamic.UnableToBuildDueToMissingFieldException;
import com.dooapp.gaedo.exceptions.finder.dynamic.UnableToBuildDueToMissingModeException;
import com.dooapp.gaedo.exceptions.finder.dynamic.UnableToBuildDueToMissingQueryExpressionException;
import com.dooapp.gaedo.exceptions.finder.dynamic.UnableToBuildDueToMissingSortingExpressionException;
import com.dooapp.gaedo.finders.FieldInformer;
import com.dooapp.gaedo.finders.FinderCrudService;
import com.dooapp.gaedo.finders.Informer;
import com.dooapp.gaedo.finders.SortingExpression;
import com.dooapp.gaedo.finders.dynamic.Combinator;
import com.dooapp.gaedo.finders.dynamic.DynamicFinder;
import com.dooapp.gaedo.finders.dynamic.DynamicFinderMethodResolver;
import com.dooapp.gaedo.finders.dynamic.Mode;
import com.dooapp.gaedo.finders.id.IdBasedService;
import com.dooapp.gaedo.properties.PropertyProvider;
import com.dooapp.gaedo.properties.PropertyProviderUtils;
import com.dooapp.gaedo.utils.BasicInvocationHandler;
import com.dooapp.gaedo.utils.CallMethodOnObjectResolver;
import com.dooapp.gaedo.utils.MethodResolver;
import com.dooapp.gaedo.utils.Utils;
import com.dooapp.gaedo.utils.VirtualMethodCreationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Logger;

public class DynamicFinderHandler<DataType>
extends BasicInvocationHandler<DataType, MethodResolver>
implements InvocationHandler {
    private static final String SORT_BY_COMBINATOR = "Then";
    private static final String SORT_BY_PREFIX = "SortBy";
    private static final Logger logger = Logger.getLogger(DynamicFinderHandler.class.getName());
    protected final FinderCrudService<DataType, ? extends Informer<DataType>> backEnd;
    protected final PropertyProvider propertyProvider;

    public DynamicFinderHandler(Class<DataType> toImplement, FinderCrudService<DataType, ?> backEnd, PropertyProvider provider) {
        super(toImplement);
        this.backEnd = backEnd;
        this.propertyProvider = provider;
        this.createAllMethodResolvers(toImplement);
    }

    public String consumeSort(String methodString, String consumableText, Map<String, String> fieldNames, DynamicFinderMethodResolver created) {
        boolean found = false;
        for (Map.Entry<String, String> fieldEntry : fieldNames.entrySet()) {
            if (!consumableText.startsWith(fieldEntry.getKey())) continue;
            consumableText = consumableText.substring(fieldEntry.getKey().length());
            FieldInformer informer = this.backEnd.getInformer().get(fieldEntry.getValue());
            found = false;
            for (SortingExpression.Direction direction : SortingExpression.Direction.values()) {
                if (!consumableText.startsWith(direction.getText())) continue;
                consumableText = consumableText.substring(direction.getText().length());
                created.addSortingExpression(informer, direction);
                found = true;
            }
            if (!found) {
                throw new UnableToBuildDueToMissingSortingExpressionException(consumableText, methodString, fieldEntry.getKey(), SortingExpression.Direction.values());
            }
            if (consumableText.startsWith(SORT_BY_COMBINATOR)) {
                consumableText = consumableText.substring(SORT_BY_COMBINATOR.length());
            }
            found = true;
        }
        return consumableText;
    }

    public String consumeFilter(String methodString, String consumableText, Map<String, String> fieldNames, DynamicFinderMethodResolver created) {
        boolean found = false;
        for (Map.Entry<String, String> fieldEntry : fieldNames.entrySet()) {
            if (!consumableText.startsWith(fieldEntry.getKey())) continue;
            consumableText = consumableText.substring(fieldEntry.getKey().length());
            FieldInformer informer = this.backEnd.getInformer().get(fieldEntry.getValue());
            Map<String, Method> queries = Utils.getUppercasedMap(informer.getClass().getMethods());
            found = false;
            for (Map.Entry<String, Method> methodEntry : queries.entrySet()) {
                if (!consumableText.startsWith(methodEntry.getKey())) continue;
                consumableText = consumableText.substring(methodEntry.getKey().length());
                created.addQueryExpression(informer, methodEntry.getValue());
                found = true;
            }
            if (!found) {
                throw new UnableToBuildDueToMissingQueryExpressionException(consumableText, methodString, fieldEntry.getKey(), queries.keySet());
            }
            for (Combinator c : Combinator.values()) {
                if (!consumableText.startsWith(c.getText())) continue;
                consumableText = consumableText.substring(c.getText().length());
                created.setCombinator(c);
            }
            found = true;
        }
        return consumableText;
    }

    @Override
    public MethodResolver createResolver(Method method) throws VirtualMethodCreationException {
        Class<Object> declaringClass = method.getDeclaringClass();
        if (declaringClass.isAssignableFrom(DynamicFinder.class)) {
            return new CallMethodOnObjectResolver(this.backEnd, method);
        }
        if (declaringClass.isAssignableFrom(DynamicFinderHandler.class)) {
            return new CallMethodOnObjectResolver(this, method);
        }
        if (declaringClass.isAssignableFrom(IdBasedService.class)) {
            return new CallMethodOnObjectResolver(this.backEnd, method);
        }
        return this.createResolverForDynamicMethod(method);
    }

    private DynamicFinderMethodResolver createResolverForDynamicMethod(String methodName, Object[] methodArgs) {
        boolean found = false;
        String consumableText = methodName;
        ParametersConstructionMode mode = ParametersConstructionMode.FILTER;
        DynamicFinderMethodResolver created = new DynamicFinderMethodResolver(this.backEnd, methodName, Object.class);
        for (Mode m : Mode.values()) {
            if (!consumableText.startsWith(m.getPrefix())) continue;
            created.setMode(m);
            found = true;
        }
        if (!found) {
            throw new UnableToBuildDueToMissingModeException(methodName);
        }
        consumableText = consumableText.substring(created.getMode().getPrefix().length());
        Map<String, String> fieldNames = Utils.getUppercasedMap(PropertyProviderUtils.getAllProperties(this.propertyProvider, this.backEnd.getContainedClass()));
        while (consumableText.length() > 0) {
            String initialText = consumableText;
            if ((consumableText = mode.consumeText(this, methodName, consumableText, fieldNames, created)).startsWith(SORT_BY_PREFIX) && mode == ParametersConstructionMode.FILTER) {
                mode = ParametersConstructionMode.SORT;
                consumableText = consumableText.substring(SORT_BY_PREFIX.length());
            }
            if (!initialText.equals(consumableText)) continue;
            throw new UnableToBuildDueToMissingFieldException(consumableText, methodName, fieldNames.keySet());
        }
        return created;
    }

    private DynamicFinderMethodResolver createResolverForDynamicMethod(Method method) {
        boolean found = false;
        String consumableText = method.getName();
        ParametersConstructionMode mode = ParametersConstructionMode.FILTER;
        DynamicFinderMethodResolver created = new DynamicFinderMethodResolver(this.backEnd, method);
        for (Mode m : Mode.values()) {
            if (!consumableText.startsWith(m.getPrefix())) continue;
            created.setMode(m);
            found = true;
        }
        if (!found) {
            throw new UnableToBuildDueToMissingModeException(method);
        }
        consumableText = consumableText.substring(created.getMode().getPrefix().length());
        Map<String, String> fieldNames = Utils.getUppercasedMap(PropertyProviderUtils.getAllProperties(this.propertyProvider, this.backEnd.getContainedClass()));
        while (consumableText.length() > 0) {
            String initialText = consumableText;
            consumableText = mode.consumeText(this, method.toGenericString(), consumableText, fieldNames, created);
            if (consumableText.startsWith(SORT_BY_PREFIX) && mode == ParametersConstructionMode.FILTER) {
                mode = ParametersConstructionMode.SORT;
                consumableText = consumableText.substring(SORT_BY_PREFIX.length());
            }
            if (!initialText.equals(consumableText)) continue;
            throw new UnableToBuildDueToMissingFieldException(consumableText, method, fieldNames.keySet());
        }
        created.checkMethod(method);
        return created;
    }

    public FinderCrudService<DataType, ? extends Informer<DataType>> getBackEnd() {
        return this.backEnd;
    }

    public Class<DataType> getToImplement() {
        return this.toImplement;
    }

    private static enum ParametersConstructionMode {
        FILTER,
        SORT;


        public String consumeText(DynamicFinderHandler handler, String methodText, String consumableText, Map<String, String> fieldNames, DynamicFinderMethodResolver created) {
            switch (this) {
                case FILTER: {
                    return handler.consumeFilter(methodText, consumableText, fieldNames, created);
                }
                case SORT: {
                    return handler.consumeSort(methodText, consumableText, fieldNames, created);
                }
            }
            throw new UnsupportedOperationException("are you kiddin or what ? You used an undeclared mode named " + this.name() + "\nplease fill a bug report at gaedo-definition");
        }
    }
}

