/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.extensions.id;

import com.dooapp.gaedo.finders.id.IdBasedService;
import com.dooapp.gaedo.properties.Property;

public abstract class AbstractGenerator<IdType, DataType> {
    protected final IdBasedService<DataType> service;
    protected final Property idProperty;

    public AbstractGenerator(IdBasedService<DataType> service, Property idProperty) {
        this.service = service;
        this.idProperty = idProperty;
    }

    public void generateIdFor(DataType value) {
        IdType id = null;
        while (this.requiresNextId(id = (IdType)this.findNextId()) || !this.service.assignId(value, id)) {
        }
    }

    protected boolean requiresNextId(IdType id) {
        try {
            return this.service.findById(id) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract IdType findNextId();
}

