/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddintake;

import datadog.trace.api.Config;
import ddtrot.dd.communication.http.HttpRetryPolicy;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.trace.api.civisibility.InstrumentationBridge;
import ddtrot.dd.trace.api.civisibility.telemetry.CiVisibilityCountMetric;
import ddtrot.dd.trace.api.intake.TrackType;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.common.writer.ddintake.TelemetryListener;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.Response;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDIntakeApi
extends RemoteApi {
    private static final Logger log = LoggerFactory.getLogger(DDIntakeApi.class);
    private static final String DD_API_KEY_HEADER = "dd-api-key";
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String GZIP_CONTENT_TYPE = "gzip";
    private final TelemetryListener telemetryListener;
    private final TrackType trackType;
    private final OkHttpClient httpClient;
    private final HttpUrl intakeUrl;
    private final String apiKey;
    private final HttpRetryPolicy.Factory retryPolicyFactory;

    public static DDIntakeApiBuilder builder() {
        return new DDIntakeApiBuilder();
    }

    private DDIntakeApi(TrackType trackType, OkHttpClient httpClient, HttpUrl intakeUrl, String apiKey, HttpRetryPolicy.Factory retryPolicyFactory) {
        super(true);
        this.telemetryListener = new TelemetryListener(trackType.endpoint);
        this.trackType = trackType;
        this.httpClient = httpClient;
        this.intakeUrl = intakeUrl;
        this.apiKey = apiKey;
        this.retryPolicyFactory = retryPolicyFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RemoteApi.Response sendSerializedTraces(Payload payload) {
        int sizeInBytes = payload.sizeInBytes();
        Request request = new Request.Builder().url(this.intakeUrl).addHeader(DD_API_KEY_HEADER, this.apiKey).addHeader(CONTENT_ENCODING_HEADER, GZIP_CONTENT_TYPE).post(payload.toRequest()).tag(OkHttpUtils.CustomListener.class, this.telemetryListener).build();
        this.totalTraces += (long)payload.traceCount();
        this.receivedTraces += (long)payload.traceCount();
        try (Response response2 = OkHttpUtils.sendWithRetries(this.httpClient, this.retryPolicyFactory, request);){
            if (response2.isSuccessful()) {
                this.countAndLogSuccessfulSend(payload.traceCount(), sizeInBytes);
                RemoteApi.Response response3 = RemoteApi.Response.success(response2.code());
                return response3;
            }
            InstrumentationBridge.getMetricCollector().add(CiVisibilityCountMetric.ENDPOINT_PAYLOAD_DROPPED, 1L, this.trackType.endpoint);
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, response2, null);
            RemoteApi.Response response = RemoteApi.Response.failed(response2.code());
            return response;
        }
        catch (ConnectException e) {
            InstrumentationBridge.getMetricCollector().add(CiVisibilityCountMetric.ENDPOINT_PAYLOAD_DROPPED, 1L, this.trackType.endpoint);
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, null);
            return RemoteApi.Response.failed(e);
        }
        catch (IOException e) {
            InstrumentationBridge.getMetricCollector().add(CiVisibilityCountMetric.ENDPOINT_PAYLOAD_DROPPED, 1L, this.trackType.endpoint);
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, e);
            return RemoteApi.Response.failed(e);
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    public static class DDIntakeApiBuilder {
        private String site = Config.get().getSite();
        private String apiVersion = "v2";
        private TrackType trackType = TrackType.NOOP;
        private long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        HttpUrl hostUrl = null;
        OkHttpClient httpClient = null;
        HttpRetryPolicy.Factory retryPolicyFactory = new HttpRetryPolicy.Factory(5, 100, 2.0, true);
        private String apiKey;

        public DDIntakeApiBuilder trackType(TrackType trackType) {
            this.trackType = trackType;
            return this;
        }

        public DDIntakeApiBuilder site(String site) {
            this.site = site;
            return this;
        }

        public DDIntakeApiBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public DDIntakeApiBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public DDIntakeApiBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public DDIntakeApiBuilder hostUrl(HttpUrl hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        DDIntakeApiBuilder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public DDIntakeApi build() {
            assert (this.apiKey != null);
            String trackName = (this.trackType != null ? this.trackType.name() : TrackType.NOOP.name()).toLowerCase(Locale.ROOT);
            if (null == this.hostUrl) {
                this.hostUrl = HttpUrl.get(String.format("https://%s-intake.%s", trackName, this.site));
            }
            HttpUrl intakeUrl = this.hostUrl.resolve(String.format("/api/%s/%s", this.apiVersion, trackName));
            OkHttpClient client = this.httpClient != null ? this.httpClient : OkHttpUtils.buildHttpClient(intakeUrl, this.timeoutMillis);
            return new DDIntakeApi(this.trackType, client, intakeUrl, this.apiKey, this.retryPolicyFactory);
        }
    }
}

