/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common;

import datadog.trace.api.interceptor.AbstractTraceInterceptor;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import ddtrot.dd.trace.api.git.GitInfo;
import ddtrot.dd.trace.api.git.GitInfoProvider;
import ddtrot.dd.trace.core.DDSpan;
import java.util.Collection;

public class GitMetadataTraceInterceptor
extends AbstractTraceInterceptor {
    public static final TraceInterceptor INSTANCE = new GitMetadataTraceInterceptor(AbstractTraceInterceptor.Priority.GIT_METADATA);

    protected GitMetadataTraceInterceptor(AbstractTraceInterceptor.Priority priority) {
        super(priority);
    }

    public Collection<? extends MutableSpan> onTraceComplete(Collection<? extends MutableSpan> trace) {
        if (trace.isEmpty()) {
            return trace;
        }
        DDSpan firstSpan = (DDSpan)trace.iterator().next();
        String ciWorkspacePath = (String)firstSpan.getTag("ci.workspace_path");
        GitInfo gitInfo = GitInfoProvider.INSTANCE.getGitInfo(ciWorkspacePath);
        firstSpan.setTag("_dd.git.repository_url", gitInfo.getRepositoryURL());
        firstSpan.setTag("_dd.git.commit.sha", gitInfo.getCommit().getSha());
        return trace;
    }
}

