/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.coverage;

import ddtrot.dd.trace.api.civisibility.InstrumentationTestBridge;
import ddtrot.dd.trace.api.civisibility.coverage.CoverageDataSupplier;
import ddtrot.dd.trace.api.civisibility.coverage.CoverageProbes;
import ddtrot.dd.trace.api.civisibility.coverage.CoverageStore;
import ddtrot.dd.trace.api.civisibility.coverage.NoOpProbes;
import ddtrot.dd.trace.api.civisibility.domain.TestContext;

public abstract class CoverageBridge {
    private static final ThreadLocal<CoverageProbes> COVERAGE_PROBES = new ThreadLocal();
    private static volatile CoverageStore.Registry COVERAGE_STORE_REGISTRY;
    private static volatile CoverageDataSupplier COVERAGE_DATA_SUPPLIER;

    public static void registerCoverageDataSupplier(CoverageDataSupplier coverageDataSupplier) {
        COVERAGE_DATA_SUPPLIER = coverageDataSupplier;
    }

    public static byte[] getCoverageData() {
        return COVERAGE_DATA_SUPPLIER != null ? COVERAGE_DATA_SUPPLIER.get() : null;
    }

    public static void registerCoverageStoreRegistry(CoverageStore.Registry coverageStoreRegistry) {
        COVERAGE_STORE_REGISTRY = coverageStoreRegistry;
    }

    public static CoverageStore.Registry getCoverageStoreRegistry() {
        return COVERAGE_STORE_REGISTRY;
    }

    public static void recordCoverage(Class<?> clazz, long classId, int probeId) {
        CoverageBridge.getCurrentCoverageProbes().record(clazz, classId, probeId);
    }

    public static void recordCoverage(Class<?> clazz) {
        CoverageBridge.getCurrentCoverageProbes().record(clazz);
    }

    public static void recordCoverage(String absolutePath) {
        CoverageBridge.getCurrentCoverageProbes().recordNonCodeResource(absolutePath);
    }

    private static CoverageProbes getCurrentCoverageProbes() {
        CoverageProbes probes = COVERAGE_PROBES.get();
        if (probes != null) {
            return probes;
        }
        TestContext currentTest = InstrumentationTestBridge.getCurrentTestContext();
        if (currentTest != null) {
            return currentTest.getCoverageStore().getProbes();
        }
        return NoOpProbes.INSTANCE;
    }

    public static void setThreadLocalCoverageProbes(CoverageProbes probes) {
        COVERAGE_PROBES.set(probes);
    }

    public static void removeThreadLocalCoverageProbes() {
        COVERAGE_PROBES.remove();
    }
}

