/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.common.socket;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;

public class NamedPipeSocket
extends Socket {
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final RandomAccessFile randomAccessFile;
    private final FileChannel fileChannel;

    public NamedPipeSocket(File pipe) throws FileNotFoundException {
        this.randomAccessFile = new RandomAccessFile(pipe, "rw");
        this.fileChannel = this.randomAccessFile.getChannel();
        this.inputStream = Channels.newInputStream(this.fileChannel);
        this.outputStream = Channels.newOutputStream(this.fileChannel);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.randomAccessFile.getChannel().isOpen()) {
            return this.inputStream;
        }
        throw new IOException("Pipe closed");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.randomAccessFile.getChannel().isOpen()) {
            return this.outputStream;
        }
        throw new IOException("Pipe closed");
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    @Override
    public boolean isClosed() {
        return !this.fileChannel.isOpen();
    }

    @Override
    public boolean isBound() {
        return !this.isClosed();
    }

    @Override
    public boolean isConnected() {
        return !this.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.isClosed();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.isClosed();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.close();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.close();
    }

    @Override
    public void bind(SocketAddress local) {
    }

    @Override
    public void connect(SocketAddress addr) {
    }

    @Override
    public void connect(SocketAddress addr, int timeout) {
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return null;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return null;
    }

    @Override
    public boolean getKeepAlive() {
        return true;
    }

    @Override
    public int getReceiveBufferSize() {
        return 0;
    }

    @Override
    public int getSendBufferSize() {
        return 0;
    }

    @Override
    public int getSoTimeout() {
        return 0;
    }

    @Override
    public void setKeepAlive(boolean on) {
    }

    @Override
    public void setReceiveBufferSize(int size) {
    }

    @Override
    public void setSendBufferSize(int size) {
    }

    @Override
    public void setSoTimeout(int timeout) {
    }
}

