/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.timgroup.statsd;

import java.net.SocketAddress;
import java.util.Objects;

public class UnixSocketAddressWithTransport
extends SocketAddress {
    private final SocketAddress address;
    private final TransportType transportType;

    public UnixSocketAddressWithTransport(SocketAddress address, TransportType transportType) {
        this.address = address;
        this.transportType = transportType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UnixSocketAddressWithTransport that = (UnixSocketAddressWithTransport)other;
        return Objects.equals(this.address, that.address) && this.transportType == that.transportType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.transportType});
    }

    SocketAddress getAddress() {
        return this.address;
    }

    TransportType getTransportType() {
        return this.transportType;
    }

    public static enum TransportType {
        UDS_STREAM("uds-stream"),
        UDS_DATAGRAM("uds-datagram"),
        UDS("uds");

        private final String transportType;

        private TransportType(String transportType) {
            this.transportType = transportType;
        }

        String getTransportType() {
            return this.transportType;
        }

        static TransportType fromScheme(String scheme) {
            switch (scheme) {
                case "unixstream": {
                    return UDS_STREAM;
                }
                case "unixgram": {
                    return UDS_DATAGRAM;
                }
                case "unix": {
                    return UDS;
                }
            }
            throw new IllegalArgumentException("Unknown scheme: " + scheme);
        }
    }
}

