/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.datadoghq.sketch.ddsketch.store;

import ddtrot.com.datadoghq.sketch.ddsketch.store.CollapsingDenseStore;
import ddtrot.com.datadoghq.sketch.ddsketch.store.Store;

public class CollapsingHighestDenseStore
extends CollapsingDenseStore {
    public CollapsingHighestDenseStore(int maxNumBins) {
        super(maxNumBins);
    }

    private CollapsingHighestDenseStore(CollapsingHighestDenseStore store) {
        super(store);
    }

    @Override
    int normalize(int index) {
        if (index > this.maxIndex) {
            if (this.isCollapsed) {
                return this.counts.length - 1;
            }
            this.extendRange(index);
            if (this.isCollapsed) {
                return this.counts.length - 1;
            }
        } else if (index < this.minIndex) {
            this.extendRange(index);
        }
        return index - this.offset;
    }

    @Override
    void adjust(int newMinIndex, int newMaxIndex) {
        if ((long)newMaxIndex - (long)newMinIndex + 1L > (long)this.counts.length) {
            newMaxIndex = newMinIndex + this.counts.length - 1;
            if (newMaxIndex <= this.minIndex) {
                double totalCount = this.getTotalCount();
                this.resetCounts();
                this.offset = newMinIndex;
                this.maxIndex = newMaxIndex;
                this.counts[this.counts.length - 1] = totalCount;
            } else {
                int shift = this.offset - newMinIndex;
                if (shift > 0) {
                    double collapsedCount = this.getTotalCount(newMaxIndex + 1, this.maxIndex);
                    this.resetCounts(newMaxIndex + 1, this.maxIndex);
                    int n = newMaxIndex - this.offset;
                    this.counts[n] = this.counts[n] + collapsedCount;
                    this.maxIndex = newMaxIndex;
                    this.shiftCounts(shift);
                } else {
                    this.shiftCounts(shift);
                    this.maxIndex = newMaxIndex;
                }
            }
            this.minIndex = newMinIndex;
            this.isCollapsed = true;
        } else {
            this.centerCounts(newMinIndex, newMaxIndex);
        }
    }

    @Override
    public Store copy() {
        return new CollapsingHighestDenseStore(this);
    }

    @Override
    public void mergeWith(Store store) {
        if (store instanceof CollapsingHighestDenseStore) {
            this.mergeWith((CollapsingHighestDenseStore)store);
        } else {
            this.getAscendingStream().forEachOrdered(this::add);
        }
    }

    private void mergeWith(CollapsingHighestDenseStore store) {
        int index;
        if (store.isEmpty()) {
            return;
        }
        if (store.minIndex < this.minIndex || store.maxIndex > this.maxIndex) {
            this.extendRange(store.minIndex, store.maxIndex);
        }
        for (index = store.maxIndex; index > this.maxIndex && index >= store.minIndex; --index) {
            int n = this.counts.length - 1;
            this.counts[n] = this.counts[n] + store.counts[index - store.offset];
        }
        while (index > store.minIndex) {
            int n = index - this.offset;
            this.counts[n] = this.counts[n] + store.counts[index - store.offset];
            --index;
        }
        if (index == store.minIndex) {
            int n = index - this.offset;
            this.counts[n] = this.counts[n] + store.counts[index - store.offset];
        }
    }
}

