/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.datadoghq.sketch.ddsketch.mapping;

import ddtrot.com.datadoghq.sketch.ddsketch.mapping.BitwiseLinearlyInterpolatedMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.CubicallyInterpolatedMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.Interpolation;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.LinearlyInterpolatedMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.LogLikeIndexMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.LogarithmicMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.QuadraticallyInterpolatedMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.QuarticallyInterpolatedMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.proto.IndexMapping;

public class IndexMappingProtoBinding {
    public static ddtrot.com.datadoghq.sketch.ddsketch.proto.IndexMapping toProto(IndexMapping indexMapping) {
        if (indexMapping instanceof LogLikeIndexMapping) {
            return IndexMappingProtoBinding.toProtoLogLike((LogLikeIndexMapping)indexMapping);
        }
        if (indexMapping instanceof BitwiseLinearlyInterpolatedMapping) {
            return IndexMappingProtoBinding.toProtoBitwiseLinear((BitwiseLinearlyInterpolatedMapping)indexMapping);
        }
        throw new IllegalArgumentException("Unknown indexmapping " + indexMapping.getClass());
    }

    private static ddtrot.com.datadoghq.sketch.ddsketch.proto.IndexMapping toProtoLogLike(LogLikeIndexMapping indexMapping) {
        return ddtrot.com.datadoghq.sketch.ddsketch.proto.IndexMapping.newBuilder().setGamma(indexMapping.gamma()).setIndexOffset(indexMapping.indexOffset()).setInterpolation(IndexMappingProtoBinding.interpolation(indexMapping.interpolation())).build();
    }

    private static ddtrot.com.datadoghq.sketch.ddsketch.proto.IndexMapping toProtoBitwiseLinear(BitwiseLinearlyInterpolatedMapping indexMapping) {
        return ddtrot.com.datadoghq.sketch.ddsketch.proto.IndexMapping.newBuilder().setGamma(indexMapping.gamma()).setInterpolation(IndexMapping.Interpolation.LINEAR).build();
    }

    public static LogLikeIndexMapping fromProto(ddtrot.com.datadoghq.sketch.ddsketch.proto.IndexMapping proto) {
        double gamma = proto.getGamma();
        double indexOffset = proto.getIndexOffset();
        switch (proto.getInterpolation()) {
            case NONE: {
                return new LogarithmicMapping(gamma, indexOffset);
            }
            case LINEAR: {
                return new LinearlyInterpolatedMapping(gamma, indexOffset);
            }
            case QUADRATIC: {
                return new QuadraticallyInterpolatedMapping(gamma, indexOffset);
            }
            case CUBIC: {
                return new CubicallyInterpolatedMapping(gamma, indexOffset);
            }
            case QUARTIC: {
                return new QuarticallyInterpolatedMapping(gamma, indexOffset);
            }
        }
        throw new IllegalArgumentException("unrecognized interpolation");
    }

    private static IndexMapping.Interpolation interpolation(Interpolation interpolation) {
        switch (interpolation) {
            case NONE: {
                return IndexMapping.Interpolation.NONE;
            }
            case LINEAR: {
                return IndexMapping.Interpolation.LINEAR;
            }
            case QUADRATIC: {
                return IndexMapping.Interpolation.QUADRATIC;
            }
            case CUBIC: {
                return IndexMapping.Interpolation.CUBIC;
            }
            case QUARTIC: {
                return IndexMapping.Interpolation.QUARTIC;
            }
        }
        throw new IllegalArgumentException("unrecognized interpolation");
    }
}

