/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jfr.exceptions;

import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.jfr.exceptions.ExceptionHistogram;
import datadog.trace.bootstrap.instrumentation.jfr.exceptions.ExceptionSampleEvent;
import datadog.trace.bootstrap.instrumentation.jfr.exceptions.ExceptionSampler;

public final class ExceptionProfiling {
    private final ExceptionHistogram histogram;
    private final ExceptionSampler sampler;
    private final boolean recordExceptionMessage;

    public static ExceptionProfiling getInstance() {
        return Holder.INSTANCE;
    }

    private ExceptionProfiling(Config config) {
        this(new ExceptionSampler(config), new ExceptionHistogram(config), config.isProfilingRecordExceptionMessage());
    }

    ExceptionProfiling(ExceptionSampler sampler, ExceptionHistogram histogram, boolean recordExceptionMessage) {
        this.sampler = sampler;
        this.histogram = histogram;
        this.recordExceptionMessage = recordExceptionMessage;
    }

    public ExceptionSampleEvent process(Throwable t, int stackDepth) {
        boolean firstHit = this.histogram.record(t);
        boolean sampled = this.sampler.sample();
        if (firstHit || sampled) {
            return new ExceptionSampleEvent(t, stackDepth, sampled, firstHit);
        }
        return null;
    }

    boolean recordExceptionMessage() {
        return this.recordExceptionMessage;
    }

    private static final class Holder {
        static final ExceptionProfiling INSTANCE = new ExceptionProfiling(Config.get());

        private Holder() {
        }
    }
}

