/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.trace.api.Config;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.api.naming.NamingSchema;
import datadog.trace.api.naming.SpanNaming;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.bootstrap.instrumentation.decorator.ClientDecorator;

public abstract class DatabaseClientDecorator<CONNECTION>
extends ClientDecorator {
    private static final DDCache<String, NamingEntry> CACHE = DDCaches.newFixedSizeCache(16);

    protected abstract String dbType();

    protected abstract String dbUser(CONNECTION var1);

    protected abstract String dbInstance(CONNECTION var1);

    protected abstract CharSequence dbHostname(CONNECTION var1);

    public AgentSpan onConnection(AgentSpan span, CONNECTION connection) {
        if (connection != null) {
            CharSequence hostName;
            span.setTag("db.user", this.dbUser(connection));
            String instanceName = this.dbInstance(connection);
            span.setTag("db.instance", instanceName);
            String serviceName = this.dbClientService(instanceName);
            if (null != serviceName) {
                span.setServiceName(serviceName);
            }
            if ((hostName = this.dbHostname(connection)) != null) {
                span.setTag("peer.hostname", hostName);
            }
        }
        return span;
    }

    public String dbService(String dbType, String instanceName) {
        if (instanceName != null && Config.get().isDbClientSplitByInstance()) {
            return this.dbClientService(instanceName);
        }
        NamingEntry entry = CACHE.computeIfAbsent(dbType, x$0 -> new NamingEntry((String)x$0));
        return entry.getService();
    }

    public String dbClientService(String instanceName) {
        String service = null;
        if (instanceName != null && Config.get().isDbClientSplitByInstance()) {
            service = Config.get().isDbClientSplitByInstanceTypeSuffix() ? instanceName + "-" + this.dbType() : instanceName;
        }
        return service;
    }

    public AgentSpan onStatement(AgentSpan span, CharSequence statement) {
        span.setResourceName(statement);
        return span;
    }

    protected void processDatabaseType(AgentSpan span, String dbType) {
        NamingEntry namingEntry = CACHE.computeIfAbsent(dbType, x$0 -> new NamingEntry((String)x$0));
        span.setTag("db.type", namingEntry.dbType);
        this.postProcessServiceAndOperationName(span, namingEntry);
    }

    protected void postProcessServiceAndOperationName(AgentSpan span, NamingEntry namingEntry) {
    }

    protected static class NamingEntry {
        private final String service;
        private final CharSequence operation;
        private final String dbType;

        private NamingEntry(String rawDbType) {
            NamingSchema.ForDatabase schema = SpanNaming.instance().namingSchema().database();
            this.dbType = schema.normalizedName(rawDbType);
            this.service = schema.service(Config.get().getServiceName(), this.dbType);
            this.operation = UTF8BytesString.create(schema.operation(this.dbType));
        }

        public String getService() {
            return this.service;
        }

        public CharSequence getOperation() {
            return this.operation;
        }

        public String getDbType() {
            return this.dbType;
        }
    }
}

