/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.naming.v0;

import datadog.trace.api.naming.NamingSchema;
import javax.annotation.Nonnull;

public class CacheNamingV0
implements NamingSchema.ForCache {
    private final boolean allowsFakeServices;

    public CacheNamingV0(boolean allowsFakeServices) {
        this.allowsFakeServices = allowsFakeServices;
    }

    @Override
    @Nonnull
    public String operation(@Nonnull String cacheSystem) {
        String postfix;
        switch (cacheSystem) {
            case "ignite": {
                postfix = ".cache";
                break;
            }
            case "hazelcast": {
                postfix = ".invoke";
                break;
            }
            default: {
                postfix = ".query";
            }
        }
        return cacheSystem + postfix;
    }

    @Override
    @Nonnull
    public String service(@Nonnull String ddService, @Nonnull String cacheSystem) {
        if (!this.allowsFakeServices) {
            return ddService;
        }
        if ("hazelcast".equals(cacheSystem)) {
            return "hazelcast-sdk";
        }
        return cacheSystem;
    }
}

