/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.iast.telemetry;

import datadog.trace.api.iast.SourceTypes;
import datadog.trace.api.iast.VulnerabilityTypes;
import datadog.trace.api.iast.telemetry.Verbosity;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public enum IastMetric {
    INSTRUMENTED_PROPAGATION("instrumented.propagation", true, Scope.GLOBAL, Verbosity.MANDATORY),
    INSTRUMENTED_SOURCE("instrumented.source", true, Scope.GLOBAL, Tag.SOURCE_TYPE, Verbosity.MANDATORY),
    INSTRUMENTED_SINK("instrumented.sink", true, Scope.GLOBAL, Tag.VULNERABILITY_TYPE, Verbosity.MANDATORY),
    EXECUTED_PROPAGATION("executed.propagation", true, Scope.REQUEST, Verbosity.DEBUG),
    EXECUTED_SOURCE("executed.source", true, Scope.REQUEST, Tag.SOURCE_TYPE, Verbosity.INFORMATION),
    EXECUTED_SINK("executed.sink", true, Scope.REQUEST, Tag.VULNERABILITY_TYPE, Verbosity.INFORMATION),
    EXECUTED_TAINTED("executed.tainted", true, Scope.REQUEST, Verbosity.DEBUG),
    REQUEST_TAINTED("request.tainted", true, Scope.REQUEST, Verbosity.INFORMATION),
    TAINTED_FLAT_MODE("tainted.flat.mode", false, Scope.REQUEST, Verbosity.INFORMATION);

    private static final int COUNT;
    private final String name;
    private final boolean common;
    private final Scope scope;
    private final Tag tag;
    private final Verbosity verbosity;
    private int index;
    private Map<String, Integer> tagIndexes;

    public static int count() {
        return COUNT;
    }

    private IastMetric(String name, boolean common, Scope scope, Verbosity verbosity) {
        this(name, common, scope, null, verbosity);
    }

    private IastMetric(String name, boolean common, Scope scope, Tag tag, Verbosity verbosity) {
        this.name = name;
        this.common = common;
        this.scope = scope;
        this.tag = tag;
        this.verbosity = verbosity;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCommon() {
        return this.common;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isEnabled(@Nonnull Verbosity verbosity) {
        return verbosity.isEnabled(this.verbosity);
    }

    public Tag getTag() {
        return this.tag;
    }

    public int getIndex(String value) {
        if (this.tag == null) {
            return this.index;
        }
        return this.tagIndexes.getOrDefault(value, -1);
    }

    static {
        int count = 0;
        for (IastMetric metric : IastMetric.values()) {
            if (metric.tag == null) {
                metric.index = count++;
                continue;
            }
            metric.tagIndexes = new HashMap<String, Integer>(metric.tag.getValues().length);
            for (String tagValue : metric.tag.getValues()) {
                metric.tagIndexes.put(tagValue, count++);
            }
        }
        COUNT = count;
    }

    public static final class Scope {
        public static final Scope GLOBAL = new Scope("global");
        public static final Scope REQUEST = new Scope("request");
        private final String name;

        private Scope(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Tag {
        private static final String[] EMPTY = new String[0];
        public static final Tag VULNERABILITY_TYPE = new Tag("vulnerability_type", VulnerabilityTypes.values()){

            @Override
            public String[] parse(String tagValue) {
                if ("RESPONSE_HEADER".equals(tagValue)) {
                    return VulnerabilityTypes.RESPONSE_HEADER_TYPES;
                }
                return EMPTY;
            }
        };
        public static final Tag SOURCE_TYPE = new Tag("source_type", SourceTypes.values());
        private final String name;
        private final String[] values;

        private Tag(String name, String ... values) {
            this.name = name;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public String[] getValues() {
            return this.values;
        }

        public String[] parse(String tagValue) {
            return EMPTY;
        }
    }
}

