/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.http;

import datadog.trace.api.http.StoredByteBody;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

class ThreadLocalCoders {
    private static final int CACHE_SIZE = 3;
    private static final Cache DECODER_CACHE = new Cache(3){

        @Override
        boolean hasName(Object ob, Object name) {
            return ((CharsetDecoder)ob).charset().equals(name);
        }

        @Override
        Object create(Object charset) {
            return ((Charset)charset).newDecoder().onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
    };
    private static final ThreadLocal<CharsetEncoder> UTF8_ENCODER_CACHE = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return StoredByteBody.UTF_8.newEncoder().onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPLACE);
        }
    };

    ThreadLocalCoders() {
    }

    public static CharsetDecoder decoderFor(Charset charset) {
        CharsetDecoder cd = (CharsetDecoder)DECODER_CACHE.forName(charset);
        cd.onMalformedInput(CodingErrorAction.REPLACE);
        cd.reset();
        return cd;
    }

    public static CharsetEncoder utf8Encoder() {
        CharsetEncoder charsetEncoder = UTF8_ENCODER_CACHE.get();
        charsetEncoder.reset();
        return charsetEncoder;
    }

    private static abstract class Cache {
        private final ThreadLocal<Object[]> cache = new ThreadLocal();
        private final int size;

        Cache(int size) {
            this.size = size;
        }

        abstract Object create(Object var1);

        private void moveToFront(Object[] oa, int i) {
            Object ob = oa[i];
            for (int j = i; j > 0; --j) {
                oa[j] = oa[j - 1];
            }
            oa[0] = ob;
        }

        abstract boolean hasName(Object var1, Object var2);

        Object forName(Object name) {
            Object ob;
            Object[] oa = this.cache.get();
            if (oa == null) {
                oa = new Object[this.size];
                this.cache.set(oa);
            } else {
                for (int i = 0; i < oa.length; ++i) {
                    Object ob2 = oa[i];
                    if (ob2 == null || !this.hasName(ob2, name)) continue;
                    if (i > 0) {
                        this.moveToFront(oa, i);
                    }
                    return ob2;
                }
            }
            oa[oa.length - 1] = ob = this.create(name);
            this.moveToFront(oa, oa.length - 1);
            return ob;
        }
    }
}

