/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CloudConfigurationRegoRule;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"complexRule", "regoRule", "resourceType"})
public class CloudConfigurationComplianceRuleOptions {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPLEX_RULE = "complexRule";
    private Boolean complexRule;
    public static final String JSON_PROPERTY_REGO_RULE = "regoRule";
    private CloudConfigurationRegoRule regoRule;
    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    private String resourceType;
    private Map<String, Object> additionalProperties;

    public CloudConfigurationComplianceRuleOptions complexRule(Boolean complexRule) {
        this.complexRule = complexRule;
        return this;
    }

    @Nullable
    @JsonProperty(value="complexRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getComplexRule() {
        return this.complexRule;
    }

    public void setComplexRule(Boolean complexRule) {
        this.complexRule = complexRule;
    }

    public CloudConfigurationComplianceRuleOptions regoRule(CloudConfigurationRegoRule regoRule) {
        this.regoRule = regoRule;
        this.unparsed |= regoRule.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="regoRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CloudConfigurationRegoRule getRegoRule() {
        return this.regoRule;
    }

    public void setRegoRule(CloudConfigurationRegoRule regoRule) {
        this.regoRule = regoRule;
    }

    public CloudConfigurationComplianceRuleOptions resourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @JsonAnySetter
    public CloudConfigurationComplianceRuleOptions putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudConfigurationComplianceRuleOptions cloudConfigurationComplianceRuleOptions = (CloudConfigurationComplianceRuleOptions)o;
        return Objects.equals(this.complexRule, cloudConfigurationComplianceRuleOptions.complexRule) && Objects.equals(this.regoRule, cloudConfigurationComplianceRuleOptions.regoRule) && Objects.equals(this.resourceType, cloudConfigurationComplianceRuleOptions.resourceType) && Objects.equals(this.additionalProperties, cloudConfigurationComplianceRuleOptions.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.complexRule, this.regoRule, this.resourceType, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudConfigurationComplianceRuleOptions {\n");
        sb.append("    complexRule: ").append(this.toIndentedString(this.complexRule)).append("\n");
        sb.append("    regoRule: ").append(this.toIndentedString(this.regoRule)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

