/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ReorderRetentionFiltersRequest;
import com.datadog.api.client.v2.model.RetentionFilterCreateRequest;
import com.datadog.api.client.v2.model.RetentionFilterCreateResponse;
import com.datadog.api.client.v2.model.RetentionFilterResponse;
import com.datadog.api.client.v2.model.RetentionFilterUpdateRequest;
import com.datadog.api.client.v2.model.RetentionFiltersResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class ApmRetentionFiltersApi {
    private ApiClient apiClient;

    public ApmRetentionFiltersApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ApmRetentionFiltersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RetentionFilterCreateResponse createApmRetentionFilter(RetentionFilterCreateRequest body) throws ApiException {
        return this.createApmRetentionFilterWithHttpInfo(body).getData();
    }

    public CompletableFuture<RetentionFilterCreateResponse> createApmRetentionFilterAsync(RetentionFilterCreateRequest body) {
        return this.createApmRetentionFilterWithHttpInfoAsync(body).thenApply(response -> (RetentionFilterCreateResponse)response.getData());
    }

    public ApiResponse<RetentionFilterCreateResponse> createApmRetentionFilterWithHttpInfo(RetentionFilterCreateRequest body) throws ApiException {
        RetentionFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createApmRetentionFilter");
        }
        String localVarPath = "/api/v2/apm/config/retention-filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.createApmRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RetentionFilterCreateResponse>(){});
    }

    public CompletableFuture<ApiResponse<RetentionFilterCreateResponse>> createApmRetentionFilterWithHttpInfoAsync(RetentionFilterCreateRequest body) {
        Invocation.Builder builder;
        RetentionFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<RetentionFilterCreateResponse>> result = new CompletableFuture<ApiResponse<RetentionFilterCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createApmRetentionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/apm/config/retention-filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.createApmRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RetentionFilterCreateResponse>> result = new CompletableFuture<ApiResponse<RetentionFilterCreateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RetentionFilterCreateResponse>(){});
    }

    public void deleteApmRetentionFilter(String filterId) throws ApiException {
        this.deleteApmRetentionFilterWithHttpInfo(filterId);
    }

    public CompletableFuture<Void> deleteApmRetentionFilterAsync(String filterId) {
        return this.deleteApmRetentionFilterWithHttpInfoAsync(filterId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteApmRetentionFilterWithHttpInfo(String filterId) throws ApiException {
        Object localVarPostBody = null;
        if (filterId == null) {
            throw new ApiException(400, "Missing the required parameter 'filterId' when calling deleteApmRetentionFilter");
        }
        String localVarPath = "/api/v2/apm/config/retention-filters/{filter_id}".replaceAll("\\{filter_id\\}", this.apiClient.escapeString(filterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.deleteApmRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteApmRetentionFilterWithHttpInfoAsync(String filterId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (filterId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'filterId' when calling deleteApmRetentionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/apm/config/retention-filters/{filter_id}".replaceAll("\\{filter_id\\}", this.apiClient.escapeString(filterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.deleteApmRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public RetentionFilterResponse getApmRetentionFilter(String filterId) throws ApiException {
        return this.getApmRetentionFilterWithHttpInfo(filterId).getData();
    }

    public CompletableFuture<RetentionFilterResponse> getApmRetentionFilterAsync(String filterId) {
        return this.getApmRetentionFilterWithHttpInfoAsync(filterId).thenApply(response -> (RetentionFilterResponse)response.getData());
    }

    public ApiResponse<RetentionFilterResponse> getApmRetentionFilterWithHttpInfo(String filterId) throws ApiException {
        Object localVarPostBody = null;
        if (filterId == null) {
            throw new ApiException(400, "Missing the required parameter 'filterId' when calling getApmRetentionFilter");
        }
        String localVarPath = "/api/v2/apm/config/retention-filters/{filter_id}".replaceAll("\\{filter_id\\}", this.apiClient.escapeString(filterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.getApmRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RetentionFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<RetentionFilterResponse>> getApmRetentionFilterWithHttpInfoAsync(String filterId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (filterId == null) {
            CompletableFuture<ApiResponse<RetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RetentionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'filterId' when calling getApmRetentionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/apm/config/retention-filters/{filter_id}".replaceAll("\\{filter_id\\}", this.apiClient.escapeString(filterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.getApmRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RetentionFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RetentionFilterResponse>(){});
    }

    public RetentionFiltersResponse listApmRetentionFilters() throws ApiException {
        return this.listApmRetentionFiltersWithHttpInfo().getData();
    }

    public CompletableFuture<RetentionFiltersResponse> listApmRetentionFiltersAsync() {
        return this.listApmRetentionFiltersWithHttpInfoAsync().thenApply(response -> (RetentionFiltersResponse)response.getData());
    }

    public ApiResponse<RetentionFiltersResponse> listApmRetentionFiltersWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/apm/config/retention-filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.listApmRetentionFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RetentionFiltersResponse>(){});
    }

    public CompletableFuture<ApiResponse<RetentionFiltersResponse>> listApmRetentionFiltersWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/apm/config/retention-filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.listApmRetentionFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RetentionFiltersResponse>> result = new CompletableFuture<ApiResponse<RetentionFiltersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RetentionFiltersResponse>(){});
    }

    public void reorderApmRetentionFilters(ReorderRetentionFiltersRequest body) throws ApiException {
        this.reorderApmRetentionFiltersWithHttpInfo(body);
    }

    public CompletableFuture<Void> reorderApmRetentionFiltersAsync(ReorderRetentionFiltersRequest body) {
        return this.reorderApmRetentionFiltersWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> reorderApmRetentionFiltersWithHttpInfo(ReorderRetentionFiltersRequest body) throws ApiException {
        ReorderRetentionFiltersRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling reorderApmRetentionFilters");
        }
        String localVarPath = "/api/v2/apm/config/retention-filters-execution-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.reorderApmRetentionFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> reorderApmRetentionFiltersWithHttpInfoAsync(ReorderRetentionFiltersRequest body) {
        Invocation.Builder builder;
        ReorderRetentionFiltersRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling reorderApmRetentionFilters"));
            return result;
        }
        String localVarPath = "/api/v2/apm/config/retention-filters-execution-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.reorderApmRetentionFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public RetentionFilterResponse updateApmRetentionFilter(String filterId, RetentionFilterUpdateRequest body) throws ApiException {
        return this.updateApmRetentionFilterWithHttpInfo(filterId, body).getData();
    }

    public CompletableFuture<RetentionFilterResponse> updateApmRetentionFilterAsync(String filterId, RetentionFilterUpdateRequest body) {
        return this.updateApmRetentionFilterWithHttpInfoAsync(filterId, body).thenApply(response -> (RetentionFilterResponse)response.getData());
    }

    public ApiResponse<RetentionFilterResponse> updateApmRetentionFilterWithHttpInfo(String filterId, RetentionFilterUpdateRequest body) throws ApiException {
        RetentionFilterUpdateRequest localVarPostBody = body;
        if (filterId == null) {
            throw new ApiException(400, "Missing the required parameter 'filterId' when calling updateApmRetentionFilter");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateApmRetentionFilter");
        }
        String localVarPath = "/api/v2/apm/config/retention-filters/{filter_id}".replaceAll("\\{filter_id\\}", this.apiClient.escapeString(filterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.updateApmRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RetentionFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<RetentionFilterResponse>> updateApmRetentionFilterWithHttpInfoAsync(String filterId, RetentionFilterUpdateRequest body) {
        Invocation.Builder builder;
        RetentionFilterUpdateRequest localVarPostBody = body;
        if (filterId == null) {
            CompletableFuture<ApiResponse<RetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RetentionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'filterId' when calling updateApmRetentionFilter"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RetentionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateApmRetentionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/apm/config/retention-filters/{filter_id}".replaceAll("\\{filter_id\\}", this.apiClient.escapeString(filterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApmRetentionFiltersApi.updateApmRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RetentionFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RetentionFilterResponse>(){});
    }
}

