/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.ml;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.ml.CreateOnlineStoreRequest;
import com.databricks.sdk.service.ml.DeleteOnlineStoreRequest;
import com.databricks.sdk.service.ml.FeatureStoreService;
import com.databricks.sdk.service.ml.GetOnlineStoreRequest;
import com.databricks.sdk.service.ml.ListOnlineStoresRequest;
import com.databricks.sdk.service.ml.ListOnlineStoresResponse;
import com.databricks.sdk.service.ml.OnlineStore;
import com.databricks.sdk.service.ml.PublishTableRequest;
import com.databricks.sdk.service.ml.PublishTableResponse;
import com.databricks.sdk.service.ml.UpdateOnlineStoreRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class FeatureStoreImpl
implements FeatureStoreService {
    private final ApiClient apiClient;

    public FeatureStoreImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public OnlineStore createOnlineStore(CreateOnlineStoreRequest request) {
        String path = "/api/2.0/feature-store/online-stores";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getOnlineStore()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, OnlineStore.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteOnlineStore(DeleteOnlineStoreRequest request) {
        String path = String.format("/api/2.0/feature-store/online-stores/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public OnlineStore getOnlineStore(GetOnlineStoreRequest request) {
        String path = String.format("/api/2.0/feature-store/online-stores/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, OnlineStore.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListOnlineStoresResponse listOnlineStores(ListOnlineStoresRequest request) {
        String path = "/api/2.0/feature-store/online-stores";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListOnlineStoresResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PublishTableResponse publishTable(PublishTableRequest request) {
        String path = String.format("/api/2.0/feature-store/tables/%s/publish", request.getSourceTableName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, PublishTableResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public OnlineStore updateOnlineStore(UpdateOnlineStoreRequest request) {
        String path = String.format("/api/2.0/feature-store/online-stores/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getOnlineStore()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, OnlineStore.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

