/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.error.details.ErrorDetails;

public class DatabricksError
extends DatabricksException {
    private final Throwable cause;
    private final String errorCode;
    private final int statusCode;
    private final ErrorDetails errorDetails;

    public DatabricksError(int statusCode) {
        this("", "OK", statusCode, null, ErrorDetails.builder().build());
    }

    public DatabricksError(String errorCode, String message) {
        this(errorCode, message, 400, null, ErrorDetails.builder().build());
    }

    public DatabricksError(String errorCode, String message, int statusCode) {
        this(errorCode, message, statusCode, null, ErrorDetails.builder().build());
    }

    public DatabricksError(String errorCode, int statusCode, Throwable cause) {
        this(errorCode, cause.getMessage(), statusCode, cause, ErrorDetails.builder().build());
    }

    public DatabricksError(String errorCode, String message, int statusCode, ErrorDetails details) {
        this(errorCode, message, statusCode, null, details);
    }

    private DatabricksError(String errorCode, String message, int statusCode, Throwable cause, ErrorDetails details) {
        super(message, cause);
        this.errorCode = errorCode;
        this.cause = cause;
        this.statusCode = statusCode;
        this.errorDetails = details == null ? ErrorDetails.builder().build() : details;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }
}

