/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.oauth.TokenSource;
import com.databricks.sdk.core.utils.Environment;
import com.databricks.sdk.core.utils.OSUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class CliTokenSource
implements TokenSource {
    private List<String> cmd;
    private String tokenTypeField;
    private String accessTokenField;
    private String expiryField;
    private Environment env;

    public CliTokenSource(List<String> cmd, String tokenTypeField, String accessTokenField, String expiryField, Environment env) {
        this.cmd = OSUtils.get(env).getCliExecutableCommand(cmd);
        this.tokenTypeField = tokenTypeField;
        this.accessTokenField = accessTokenField;
        this.expiryField = expiryField;
        this.env = env;
    }

    static Instant parseExpiry(String expiry) {
        try {
            return OffsetDateTime.parse(expiry).toInstant();
        }
        catch (DateTimeParseException e) {
            DateTimeParseException parseException = e;
            String multiplePrecisionPattern = "[SSSSSSSSS][SSSSSSSS][SSSSSSS][SSSSSS][SSSSS][SSSS][SSS][SS][S]";
            List<String> datePatterns = Arrays.asList("yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss." + multiplePrecisionPattern);
            for (String pattern : datePatterns) {
                try {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
                    LocalDateTime dateTime = LocalDateTime.parse(expiry, formatter);
                    return dateTime.atZone(ZoneId.systemDefault()).toInstant();
                }
                catch (DateTimeParseException e2) {
                    parseException.addSuppressed(e2);
                }
            }
            throw parseException;
        }
    }

    private String getProcessStream(InputStream stream) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        return new String(bytes);
    }

    @Override
    public Token getToken() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(this.cmd);
            processBuilder.environment().putAll(this.env.getEnv());
            Process process = processBuilder.start();
            String stdout = this.getProcessStream(process.getInputStream());
            String stderr = this.getProcessStream(process.getErrorStream());
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                if (stderr.contains("not found")) {
                    throw new DatabricksException(stderr);
                }
                throw new IOException(stderr);
            }
            JsonNode jsonNode = new ObjectMapper().readTree(stdout);
            String tokenType = jsonNode.get(this.tokenTypeField).asText();
            String accessToken = jsonNode.get(this.accessTokenField).asText();
            String expiry = jsonNode.get(this.expiryField).asText();
            Instant expiresOn = CliTokenSource.parseExpiry(expiry);
            return new Token(accessToken, tokenType, expiresOn);
        }
        catch (DatabricksException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new DatabricksException("cannot get access token: " + e.getMessage(), e);
        }
    }
}

