/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sharing.AuthenticationType;
import com.databricks.sdk.service.sharing.CreateProvider;
import com.databricks.sdk.service.sharing.DeleteProviderRequest;
import com.databricks.sdk.service.sharing.GetProviderRequest;
import com.databricks.sdk.service.sharing.ListProviderSharesResponse;
import com.databricks.sdk.service.sharing.ListProvidersRequest;
import com.databricks.sdk.service.sharing.ListProvidersResponse;
import com.databricks.sdk.service.sharing.ListSharesRequest;
import com.databricks.sdk.service.sharing.ProviderInfo;
import com.databricks.sdk.service.sharing.ProviderShare;
import com.databricks.sdk.service.sharing.ProvidersImpl;
import com.databricks.sdk.service.sharing.ProvidersService;
import com.databricks.sdk.service.sharing.UpdateProvider;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ProvidersAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ProvidersAPI.class);
    private final ProvidersService impl;

    public ProvidersAPI(ApiClient apiClient) {
        this.impl = new ProvidersImpl(apiClient);
    }

    public ProvidersAPI(ProvidersService mock) {
        this.impl = mock;
    }

    public ProviderInfo create(String name, AuthenticationType authenticationType) {
        return this.create(new CreateProvider().setName(name).setAuthenticationType(authenticationType));
    }

    public ProviderInfo create(CreateProvider request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteProviderRequest().setName(name));
    }

    public void delete(DeleteProviderRequest request) {
        this.impl.delete(request);
    }

    public ProviderInfo get(String name) {
        return this.get(new GetProviderRequest().setName(name));
    }

    public ProviderInfo get(GetProviderRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ProviderInfo> list(ListProvidersRequest request) {
        return new Paginator(request, this.impl::list, ListProvidersResponse::getProviders, response -> null);
    }

    public Iterable<ProviderShare> listShares(String name) {
        return this.listShares(new ListSharesRequest().setName(name));
    }

    public Iterable<ProviderShare> listShares(ListSharesRequest request) {
        return new Paginator(request, this.impl::listShares, ListProviderSharesResponse::getShares, response -> null);
    }

    public ProviderInfo update(String name) {
        return this.update(new UpdateProvider().setName(name));
    }

    public ProviderInfo update(UpdateProvider request) {
        return this.impl.update(request);
    }

    public ProvidersService impl() {
        return this.impl;
    }
}

