/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.dashboards;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.dashboards.CreateDashboardRequest;
import com.databricks.sdk.service.dashboards.Dashboard;
import com.databricks.sdk.service.dashboards.GetDashboardRequest;
import com.databricks.sdk.service.dashboards.GetPublishedDashboardRequest;
import com.databricks.sdk.service.dashboards.LakeviewImpl;
import com.databricks.sdk.service.dashboards.LakeviewService;
import com.databricks.sdk.service.dashboards.MigrateDashboardRequest;
import com.databricks.sdk.service.dashboards.PublishRequest;
import com.databricks.sdk.service.dashboards.PublishedDashboard;
import com.databricks.sdk.service.dashboards.TrashDashboardRequest;
import com.databricks.sdk.service.dashboards.UnpublishDashboardRequest;
import com.databricks.sdk.service.dashboards.UpdateDashboardRequest;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class LakeviewAPI {
    private static final Logger LOG = LoggerFactory.getLogger(LakeviewAPI.class);
    private final LakeviewService impl;

    public LakeviewAPI(ApiClient apiClient) {
        this.impl = new LakeviewImpl(apiClient);
    }

    public LakeviewAPI(LakeviewService mock) {
        this.impl = mock;
    }

    public Dashboard create(String displayName) {
        return this.create(new CreateDashboardRequest().setDisplayName(displayName));
    }

    public Dashboard create(CreateDashboardRequest request) {
        return this.impl.create(request);
    }

    public Dashboard get(String dashboardId) {
        return this.get(new GetDashboardRequest().setDashboardId(dashboardId));
    }

    public Dashboard get(GetDashboardRequest request) {
        return this.impl.get(request);
    }

    public PublishedDashboard getPublished(String dashboardId) {
        return this.getPublished(new GetPublishedDashboardRequest().setDashboardId(dashboardId));
    }

    public PublishedDashboard getPublished(GetPublishedDashboardRequest request) {
        return this.impl.getPublished(request);
    }

    public Dashboard migrate(String sourceDashboardId) {
        return this.migrate(new MigrateDashboardRequest().setSourceDashboardId(sourceDashboardId));
    }

    public Dashboard migrate(MigrateDashboardRequest request) {
        return this.impl.migrate(request);
    }

    public PublishedDashboard publish(String dashboardId) {
        return this.publish(new PublishRequest().setDashboardId(dashboardId));
    }

    public PublishedDashboard publish(PublishRequest request) {
        return this.impl.publish(request);
    }

    public void trash(String dashboardId) {
        this.trash(new TrashDashboardRequest().setDashboardId(dashboardId));
    }

    public void trash(TrashDashboardRequest request) {
        this.impl.trash(request);
    }

    public void unpublish(String dashboardId) {
        this.unpublish(new UnpublishDashboardRequest().setDashboardId(dashboardId));
    }

    public void unpublish(UnpublishDashboardRequest request) {
        this.impl.unpublish(request);
    }

    public Dashboard update(String dashboardId) {
        return this.update(new UpdateDashboardRequest().setDashboardId(dashboardId));
    }

    public Dashboard update(UpdateDashboardRequest request) {
        return this.impl.update(request);
    }

    public LakeviewService impl() {
        return this.impl;
    }
}

