/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateVolumeRequestContent;
import com.databricks.sdk.service.catalog.DeleteVolumeRequest;
import com.databricks.sdk.service.catalog.ListVolumesRequest;
import com.databricks.sdk.service.catalog.ListVolumesResponseContent;
import com.databricks.sdk.service.catalog.ReadVolumeRequest;
import com.databricks.sdk.service.catalog.UpdateVolumeRequestContent;
import com.databricks.sdk.service.catalog.VolumeInfo;
import com.databricks.sdk.service.catalog.VolumeType;
import com.databricks.sdk.service.catalog.VolumesImpl;
import com.databricks.sdk.service.catalog.VolumesService;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class VolumesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(VolumesAPI.class);
    private final VolumesService impl;

    public VolumesAPI(ApiClient apiClient) {
        this.impl = new VolumesImpl(apiClient);
    }

    public VolumesAPI(VolumesService mock) {
        this.impl = mock;
    }

    public VolumeInfo create(String catalogName, String schemaName, String name, VolumeType volumeType) {
        return this.create(new CreateVolumeRequestContent().setCatalogName(catalogName).setSchemaName(schemaName).setName(name).setVolumeType(volumeType));
    }

    public VolumeInfo create(CreateVolumeRequestContent request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteVolumeRequest().setName(name));
    }

    public void delete(DeleteVolumeRequest request) {
        this.impl.delete(request);
    }

    public Iterable<VolumeInfo> list(String catalogName, String schemaName) {
        return this.list(new ListVolumesRequest().setCatalogName(catalogName).setSchemaName(schemaName));
    }

    public Iterable<VolumeInfo> list(ListVolumesRequest request) {
        return new Paginator(request, this.impl::list, ListVolumesResponseContent::getVolumes, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public VolumeInfo read(String name) {
        return this.read(new ReadVolumeRequest().setName(name));
    }

    public VolumeInfo read(ReadVolumeRequest request) {
        return this.impl.read(request);
    }

    public VolumeInfo update(String name) {
        return this.update(new UpdateVolumeRequestContent().setName(name));
    }

    public VolumeInfo update(UpdateVolumeRequestContent request) {
        return this.impl.update(request);
    }

    public VolumesService impl() {
        return this.impl;
    }
}

