/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.AssignResponse;
import com.databricks.sdk.service.catalog.CreateMetastore;
import com.databricks.sdk.service.catalog.CreateMetastoreAssignment;
import com.databricks.sdk.service.catalog.DeleteMetastoreRequest;
import com.databricks.sdk.service.catalog.DeleteResponse;
import com.databricks.sdk.service.catalog.GetMetastoreRequest;
import com.databricks.sdk.service.catalog.GetMetastoreSummaryResponse;
import com.databricks.sdk.service.catalog.ListMetastoresResponse;
import com.databricks.sdk.service.catalog.MetastoreAssignment;
import com.databricks.sdk.service.catalog.MetastoreInfo;
import com.databricks.sdk.service.catalog.MetastoresService;
import com.databricks.sdk.service.catalog.UnassignRequest;
import com.databricks.sdk.service.catalog.UnassignResponse;
import com.databricks.sdk.service.catalog.UpdateAssignmentResponse;
import com.databricks.sdk.service.catalog.UpdateMetastore;
import com.databricks.sdk.service.catalog.UpdateMetastoreAssignment;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class MetastoresImpl
implements MetastoresService {
    private final ApiClient apiClient;

    public MetastoresImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void assign(CreateMetastoreAssignment request) {
        String path = String.format("/api/2.1/unity-catalog/workspaces/%s/metastore", request.getWorkspaceId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PUT(path, request, AssignResponse.class, headers);
    }

    @Override
    public MetastoreInfo create(CreateMetastore request) {
        String path = "/api/2.1/unity-catalog/metastores";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, MetastoreInfo.class, headers);
    }

    @Override
    public MetastoreAssignment current() {
        String path = "/api/2.1/unity-catalog/current-metastore-assignment";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, MetastoreAssignment.class, headers);
    }

    @Override
    public void delete(DeleteMetastoreRequest request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s", request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public MetastoreInfo get(GetMetastoreRequest request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s", request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, MetastoreInfo.class, headers);
    }

    @Override
    public ListMetastoresResponse list() {
        String path = "/api/2.1/unity-catalog/metastores";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, ListMetastoresResponse.class, headers);
    }

    @Override
    public GetMetastoreSummaryResponse summary() {
        String path = "/api/2.1/unity-catalog/metastore_summary";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, GetMetastoreSummaryResponse.class, headers);
    }

    @Override
    public void unassign(UnassignRequest request) {
        String path = String.format("/api/2.1/unity-catalog/workspaces/%s/metastore", request.getWorkspaceId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, UnassignResponse.class, headers);
    }

    @Override
    public MetastoreInfo update(UpdateMetastore request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s", request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, MetastoreInfo.class, headers);
    }

    @Override
    public void updateAssignment(UpdateMetastoreAssignment request) {
        String path = String.format("/api/2.1/unity-catalog/workspaces/%s/metastore", request.getWorkspaceId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, UpdateAssignmentResponse.class, headers);
    }
}

