/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.support.channels;

import com.databricks.client.support.channels.FramedSocketChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;

class FramedTcpSocketChannel
extends FramedSocketChannel {
    private final SocketChannel m_channel;
    private final ByteBuffer m_lenBuf = ByteBuffer.allocate(2);
    private char m_truncatedLen = '\u0000';

    FramedTcpSocketChannel(SocketChannel socketChannel) {
        this.m_channel = socketChannel;
        this.m_lenBuf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public SelectableChannel getChannel() {
        return this.m_channel;
    }

    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        return this.m_channel.connect(socketAddress);
    }

    @Override
    public int readFrame(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        if (this.m_lenBuf.hasRemaining()) {
            n2 = this.m_channel.read(this.m_lenBuf);
            if (n2 <= 0) {
                return n2;
            }
            if (this.m_lenBuf.hasRemaining()) {
                return 0;
            }
            this.m_lenBuf.flip();
            n = this.m_lenBuf.getChar();
            byteBuffer.limit(Math.min(n, byteBuffer.capacity()));
            this.m_truncatedLen = (char)(n - byteBuffer.limit());
        }
        if (byteBuffer.hasRemaining()) {
            n2 = this.m_channel.read(byteBuffer);
            if (n2 <= 0) {
                return n2;
            }
            if (byteBuffer.hasRemaining()) {
                return 0;
            }
        }
        if (this.m_truncatedLen > '\u0000') {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(this.m_truncatedLen);
            n = this.m_channel.read(byteBuffer2);
            if (n <= 0) {
                return n;
            }
            this.m_truncatedLen = (char)(this.m_truncatedLen - byteBuffer2.position());
            if (this.m_truncatedLen > '\u0000') {
                return 0;
            }
        }
        this.m_lenBuf.clear();
        return byteBuffer.limit();
    }

    @Override
    public int writeFrame(ByteBuffer byteBuffer) throws IOException {
        int n;
        if (this.m_lenBuf.hasRemaining()) {
            if (this.m_lenBuf.position() == 0) {
                assert (byteBuffer.limit() <= 65535);
                this.m_lenBuf.putChar((char)byteBuffer.limit());
                this.m_lenBuf.flip();
            }
            if ((n = this.m_channel.write(this.m_lenBuf)) <= 0) {
                return n;
            }
            if (this.m_lenBuf.hasRemaining()) {
                return 0;
            }
        }
        if ((n = this.m_channel.write(byteBuffer)) <= 0) {
            return n;
        }
        if (byteBuffer.hasRemaining()) {
            return 0;
        }
        this.m_lenBuf.clear();
        return byteBuffer.limit();
    }
}

