/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic;

import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;

public abstract class AbstractSmallIntBinArithFunctor
implements IBinaryArithmeticFunctor {
    protected boolean m_isSigned;

    protected AbstractSmallIntBinArithFunctor(boolean bl) {
        this.m_isSigned = bl;
    }

    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        int n;
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        int n2 = iSqlDataWrapper.getSmallInt();
        int n3 = this.calculate(n2, n = iSqlDataWrapper2.getSmallInt());
        if (!this.checkRange(n3)) {
            throw SQLEngineExceptionFactory.numArithOverflowException();
        }
        eTDataRequest.getData().setSmallInt(n3);
        return false;
    }

    protected abstract int calculate(int var1, int var2) throws ErrorException;

    private boolean checkRange(long l) {
        if (this.m_isSigned) {
            return -32768L <= l && l <= 32767L;
        }
        return 0L <= l && l <= 65535L;
    }
}

