/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.temptable.column;

import com.databricks.client.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.databricks.client.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.databricks.client.sqlengine.executor.etree.temptable.column.IColumnSlice;
import java.util.UUID;

public final class GuidColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = -3523299136239815995L;
    private UUID[] m_data;
    private final int m_columnNumber;

    public GuidColumnSlice(int n, int n2) {
        this.m_data = new UUID[n];
        this.m_columnNumber = n2;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public boolean isNull(int n) {
        return null == this.m_data[n];
    }

    @Override
    public void setNull(int n) {
        this.m_data[n] = null;
    }

    @Override
    public UUID getGuid(int n) {
        return this.m_data[n];
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.GUID;
    }

    @Override
    public void setGuid(int n, UUID uUID) {
        this.m_data[n] = uUID;
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        GuidColumnSlice guidColumnSlice = (GuidColumnSlice)iColumnSlice;
        System.arraycopy(guidColumnSlice.m_data, n, this.m_data, n3, n2);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return (double)javaSize.getObjectShellSize() + 2.0 * (double)javaSize.getLongSize();
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectRefSize();
    }
}

