/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aebuilder.relation;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.relation.AEQuerySpecBuilder;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.statement.AEQueryBuilder;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECommonTableExprScope;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEExcept;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETableConstructor;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEUnion;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEWithClause;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEDefault;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.databricks.client.sqlengine.exceptions.SQLEngineException;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.parser.parsetree.IPTNode;
import com.databricks.client.sqlengine.parser.parsetree.PTEmptyNode;
import com.databricks.client.sqlengine.parser.parsetree.PTFlagNode;
import com.databricks.client.sqlengine.parser.parsetree.PTIdentifierNode;
import com.databricks.client.sqlengine.parser.parsetree.PTListNode;
import com.databricks.client.sqlengine.parser.parsetree.PTNonterminalNode;
import com.databricks.client.sqlengine.parser.type.PTFlagType;
import com.databricks.client.sqlengine.parser.type.PTListType;
import com.databricks.client.sqlengine.parser.type.PTNonterminalType;
import com.databricks.client.sqlengine.parser.type.PTPositionalType;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.exceptions.DiagState;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AERelationalExprBuilder
extends AEBuilderBase<AERelationalExpr> {
    private boolean m_isQueryCorrelated;
    private boolean m_startNewQS;

    public AERelationalExprBuilder(AEQueryScope aEQueryScope, boolean bl) {
        super(aEQueryScope);
        if (null == aEQueryScope) {
            throw new NullPointerException("Query scope cannot be null.");
        }
        this.m_isQueryCorrelated = false;
        this.m_startNewQS = bl;
    }

    public boolean isQueryCorrelated() {
        return this.m_isQueryCorrelated;
    }

    @Override
    public AERelationalExpr visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        switch (pTNonterminalNode.getNonterminalType()) {
            case SELECT_STATEMENT: {
                return this.buildSelectStatement(pTNonterminalNode);
            }
            case SORTED_SELECT_STATEMENT: {
                return this.buildSortedSelectStatement(pTNonterminalNode);
            }
            case UNION: 
            case UNION_ALL: {
                if (!this.m_startNewQS) {
                    this.getQueryScope().setHasSetOperation(true);
                }
                return this.buildUnion(pTNonterminalNode);
            }
            case EXCEPT: 
            case EXCEPT_ALL: {
                if (!this.m_startNewQS) {
                    this.getQueryScope().setHasSetOperation(true);
                }
                return this.buildExcept(pTNonterminalNode);
            }
            case QUERY_SPEC_WITH_WITH_CLAUSE: {
                return this.buildCommonTableExprScope(pTNonterminalNode);
            }
            case TOP_LEVEL_SELECT_STATEMENT: {
                return new AEQueryBuilder(this.getQueryScope()).buildRelExpr(pTNonterminalNode);
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    @Override
    public AERelationalExpr visit(PTListNode pTListNode) throws ErrorException {
        switch (pTListNode.getListType()) {
            case TABLE_VALUE_LIST: {
                return this.buildTableValueList(pTListNode, null);
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    public AERelationalExpr buildTableValueList(PTListNode pTListNode, List<IColumn> list) throws ErrorException {
        assert (PTListType.TABLE_VALUE_LIST == pTListNode.getListType());
        if (pTListNode.numChildren() < 1) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        ArrayList<AEValueExprList> arrayList = new ArrayList<AEValueExprList>();
        AEValueExprBuilder aEValueExprBuilder = new AEValueExprBuilder(this.getQueryScope());
        int n = -1;
        Iterator<IPTNode> iterator = pTListNode.getChildItr();
        while (iterator.hasNext()) {
            PTListNode pTListNode2;
            IPTNode iPTNode = iterator.next();
            PTListNode pTListNode3 = pTListNode2 = iPTNode instanceof PTListNode ? (PTListNode)iPTNode : null;
            if (null == pTListNode2) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            if (-1 == n) {
                n = pTListNode2.numChildren();
            } else if (pTListNode2.numChildren() != n) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.TABLE_VALUE_CONSTRUCTOR_ROWS_INCONSISTENT_CARDINALITY.name());
            }
            AEValueExprList aEValueExprList = AERelationalExprBuilder.buildRowValueConstructor(pTListNode2, aEValueExprBuilder);
            if (null != list) {
                if (aEValueExprList.getNumChildren() != list.size()) {
                    throw new SQLEngineException(DiagState.DIAG_INSERT_VAL_LIST_COL_LIST_MISMATCH, SQLEngineMessageKey.INVALID_NUMBER_INSERT_VALUES.name(), new String[]{"" + aEValueExprList.getNumChildren(), "" + list.size()});
                }
                for (int i = 0; i < aEValueExprList.getNumChildren(); ++i) {
                    AEValueExpr aEValueExpr = (AEValueExpr)aEValueExprList.getChild(i);
                    if (!(aEValueExpr instanceof AEDefault)) continue;
                    AEDefault aEDefault = (AEDefault)aEValueExpr;
                    aEDefault.setMetadata(list.get(i));
                }
            }
            arrayList.add(aEValueExprList);
        }
        return new AETableConstructor(arrayList, list, this.getQueryScope().getDataEngine().getContext().getCoercionHandler());
    }

    private AERelationalExpr buildSelectStatement(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        AEQueryScope aEQueryScope = this.m_startNewQS ? this.getQueryScope().createChildScope() : this.getQueryScope();
        AERelationalExpr aERelationalExpr = (AERelationalExpr)new AEQuerySpecBuilder(aEQueryScope).build(pTNonterminalNode);
        this.m_isQueryCorrelated = aEQueryScope.isQueryCorrelated();
        return aERelationalExpr;
    }

    private AERelationalExpr buildSortedSelectStatement(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        Object object = AEBuilderCheck.nonTerminal(PTNonterminalType.ORDER_BY).withExactChildren(PTPositionalType.SORT_SPEC_LIST, AEBuilderCheck.list(PTListType.SORT_SPECIFICATION_LIST));
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.nonTerminal().withExactChildren(PTPositionalType.SELECT, AEBuilderCheck.nonEmpty(), PTPositionalType.ORDER_BY, (AEBuilderCheck.ParseTreeMatcher)object));
        object = this.m_startNewQS ? this.getQueryScope().createChildScope() : this.getQueryScope();
        PTNonterminalNode pTNonterminalNode2 = (PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.SELECT);
        IPTNode iPTNode = pTNonterminalNode2.getChild(PTPositionalType.SELECT_LIMIT);
        if (null == iPTNode || iPTNode.isEmptyNode()) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.ORDER_BY_IN_SUBQUERY_WITHOUT_TOP.name());
        }
        PTNonterminalNode pTNonterminalNode3 = (PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.ORDER_BY);
        PTListNode pTListNode = (PTListNode)pTNonterminalNode3.getChild(PTPositionalType.SORT_SPEC_LIST);
        ((AEQueryScope)object).setPtSortSpecList(pTListNode);
        ((AEQueryScope)object).setHasOrderBy();
        AERelationalExpr aERelationalExpr = (AERelationalExpr)new AERelationalExprBuilder((AEQueryScope)object, false).build(pTNonterminalNode2);
        this.m_isQueryCorrelated = ((AEQueryScope)object).isQueryCorrelated();
        return aERelationalExpr;
    }

    private AEExcept buildExcept(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        boolean bl;
        if (pTNonterminalNode.numChildren() != 2) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.BINARY_LEFT);
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.BINARY_RIGHT);
        if (iPTNode == null || iPTNode2 == null) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        switch (pTNonterminalNode.getNonterminalType()) {
            case EXCEPT: {
                bl = false;
                break;
            }
            case EXCEPT_ALL: {
                bl = true;
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
        }
        AERelationalExprBuilder aERelationalExprBuilder = new AERelationalExprBuilder(this.getQueryScope(), this.m_startNewQS);
        AERelationalExprBuilder aERelationalExprBuilder2 = new AERelationalExprBuilder(this.getQueryScope(), true);
        AERelationalExpr aERelationalExpr = (AERelationalExpr)aERelationalExprBuilder.build(iPTNode);
        AERelationalExpr aERelationalExpr2 = (AERelationalExpr)aERelationalExprBuilder2.build(iPTNode2);
        AERelationalExprBuilder.validateSetOperands(aERelationalExpr, aERelationalExpr2, bl ? "EXCEPT ALL" : "EXCEPT");
        return new AEExcept(aERelationalExpr, aERelationalExpr2, bl, this.getQueryScope().getDataEngine().getContext().getCoercionHandler());
    }

    private AEUnion buildUnion(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        boolean bl;
        if (pTNonterminalNode.numChildren() != 2) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.BINARY_LEFT);
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.BINARY_RIGHT);
        if (iPTNode == null || iPTNode2 == null) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        switch (pTNonterminalNode.getNonterminalType()) {
            case UNION: {
                bl = false;
                break;
            }
            case UNION_ALL: {
                bl = true;
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
        }
        AERelationalExprBuilder aERelationalExprBuilder = new AERelationalExprBuilder(this.getQueryScope(), this.m_startNewQS);
        AERelationalExprBuilder aERelationalExprBuilder2 = new AERelationalExprBuilder(this.getQueryScope(), true);
        AERelationalExpr aERelationalExpr = (AERelationalExpr)aERelationalExprBuilder.build(iPTNode);
        AERelationalExpr aERelationalExpr2 = (AERelationalExpr)aERelationalExprBuilder2.build(iPTNode2);
        AERelationalExprBuilder.validateSetOperands(aERelationalExpr, aERelationalExpr2, bl ? "UNION ALL" : "UNION");
        this.m_isQueryCorrelated = aERelationalExprBuilder.isQueryCorrelated() || aERelationalExprBuilder2.isQueryCorrelated();
        return new AEUnion(aERelationalExpr, aERelationalExpr2, bl, this.getQueryScope().getDataEngine().getContext().getCoercionHandler());
    }

    private boolean isRecursive(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        IPTNode iPTNode = AERelationalExprBuilder.getChild(pTNonterminalNode, PTPositionalType.WITH_CLAUSE_TYPE);
        if (iPTNode instanceof PTEmptyNode) {
            return false;
        }
        if (((PTFlagNode)iPTNode).getFlagType() != PTFlagType.RECURSIVE) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        return true;
    }

    private static IPTNode getChild(PTNonterminalNode pTNonterminalNode, PTPositionalType pTPositionalType) throws ErrorException {
        IPTNode iPTNode = pTNonterminalNode.getChild(pTPositionalType);
        if (iPTNode == null) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        return iPTNode;
    }

    private static <T> T getChild(PTNonterminalNode pTNonterminalNode, PTPositionalType pTPositionalType, Class<T> clazz) throws ErrorException {
        IPTNode iPTNode = AERelationalExprBuilder.getChild(pTNonterminalNode, pTPositionalType);
        if (!clazz.isInstance(iPTNode)) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        return clazz.cast(iPTNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AECommonTableExprScope buildCommonTableExprScope(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        assert (pTNonterminalNode.getNonterminalType() == PTNonterminalType.QUERY_SPEC_WITH_WITH_CLAUSE);
        if (this.isRecursive(pTNonterminalNode)) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.RECURSIVE_WITH_CLAUSE_NOT_SUPP.name());
        }
        PTListNode pTListNode = AERelationalExprBuilder.getChild(pTNonterminalNode, PTPositionalType.COMMON_TABLE_ESPRESSIONS, PTListNode.class);
        IPTNode iPTNode = AERelationalExprBuilder.getChild(pTNonterminalNode, PTPositionalType.QUERY_EXPRESSION);
        AEWithClause aEWithClause = new AEWithClause();
        AEQueryScope aEQueryScope = this.getQueryScope().createChildScope();
        aEQueryScope.setWithClause(aEWithClause);
        try {
            AERelationalExpr aERelationalExpr;
            Object object2;
            for (Object object2 : pTListNode) {
                aERelationalExpr = this.buildWithClauseElement((IPTNode)object2, aEQueryScope);
                if (aERelationalExpr.isCorrelated()) {
                    this.m_isQueryCorrelated = true;
                }
                aEWithClause.addCommonTableExpression((AENamedRelationalExpr)aERelationalExpr);
            }
            AERelationalExprBuilder aERelationalExprBuilder = new AERelationalExprBuilder(aEQueryScope, false);
            object2 = (AERelationalExpr)aERelationalExprBuilder.build(iPTNode);
            if (aERelationalExprBuilder.isQueryCorrelated()) {
                this.m_isQueryCorrelated = true;
            }
            aERelationalExpr = new AECommonTableExprScope(aEWithClause, (AERelationalExpr)object2, this.generateCteScopeId());
            return aERelationalExpr;
        }
        finally {
            aEQueryScope.setWithClause(null);
        }
    }

    private long generateCteScopeId() {
        return this.getQueryScope().getDataEngine().getContext().generateCommonTableExprScopeID();
    }

    private AESubQuery buildWithClauseElement(IPTNode iPTNode, AEQueryScope aEQueryScope) throws ErrorException {
        if (!(iPTNode instanceof PTNonterminalNode)) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode;
        if (pTNonterminalNode.getNonterminalType() != PTNonterminalType.COMMON_TABLE_EXPRESSION) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        PTIdentifierNode pTIdentifierNode = AERelationalExprBuilder.getChild(pTNonterminalNode, PTPositionalType.NAME, PTIdentifierNode.class);
        IPTNode iPTNode2 = AERelationalExprBuilder.getChild(pTNonterminalNode, PTPositionalType.COLUMN_LIST);
        IPTNode iPTNode3 = AERelationalExprBuilder.getChild(pTNonterminalNode, PTPositionalType.QUERY_EXPRESSION);
        if (!(iPTNode3 instanceof PTNonterminalNode) || ((PTNonterminalNode)iPTNode3).getNonterminalType() != PTNonterminalType.SUBQUERY) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        IPTNode iPTNode4 = ((PTNonterminalNode)iPTNode3).getChild(PTPositionalType.SINGLE_CHILD);
        IPTNode iPTNode5 = AERelationalExprBuilder.getChild(pTNonterminalNode, PTPositionalType.SEARCH_CLAUSE);
        IPTNode iPTNode6 = AERelationalExprBuilder.getChild(pTNonterminalNode, PTPositionalType.CYCLE_CLAUSE);
        if (!(iPTNode5 instanceof PTEmptyNode) || !(iPTNode6 instanceof PTEmptyNode)) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.SEARCH_OR_CYCLE_WITHOUT_REC.name());
        }
        AERelationalExprBuilder aERelationalExprBuilder = new AERelationalExprBuilder(aEQueryScope, true);
        AERelationalExpr aERelationalExpr = (AERelationalExpr)aERelationalExprBuilder.build(iPTNode4);
        AESubQuery aESubQuery = new AESubQuery(aERelationalExpr, aERelationalExprBuilder.isQueryCorrelated(), false);
        aESubQuery.setCorrelationName(pTIdentifierNode.getIdentifier());
        if (iPTNode2 instanceof PTListNode) {
            aESubQuery.overrideColumnNames(this.buildOverridenColumnNames((PTListNode)iPTNode2), true);
        } else if (!(iPTNode2 instanceof PTEmptyNode)) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        return aESubQuery;
    }

    private List<String> buildOverridenColumnNames(PTListNode pTListNode) throws ErrorException {
        if (pTListNode.getListType() != PTListType.COLUMN_NAME_LIST) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        ArrayList<String> arrayList = new ArrayList<String>(pTListNode.numChildren());
        for (IPTNode iPTNode : pTListNode) {
            if (!(iPTNode instanceof PTIdentifierNode)) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            arrayList.add(((PTIdentifierNode)iPTNode).getIdentifier());
        }
        return arrayList;
    }

    private static AEValueExprList buildRowValueConstructor(PTListNode pTListNode, AEValueExprBuilder aEValueExprBuilder) throws ErrorException {
        if (PTListType.ROW_VALUE_LIST != pTListNode.getListType()) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        AEValueExprList aEValueExprList = new AEValueExprList();
        for (int i = 0; i < pTListNode.numChildren(); ++i) {
            aEValueExprList.addNode(aEValueExprBuilder.build(pTListNode.getChild(i)));
        }
        return aEValueExprList;
    }

    private static void validateSetOperands(AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2, String string) throws ErrorException {
        if (aERelationalExpr.getColumnCount() != aERelationalExpr2.getColumnCount()) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.SET_OP_INVALID_NUM_COLUMNS.name(), new String[]{string});
        }
    }
}

