/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.api;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.api.HS2OAuthClientWrapper;
import com.databricks.client.hivecommon.telemetry.TelemetryManager;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.oauth.AuthorizationCodeOAuthProvider;
import com.databricks.client.jdbc.oauth.AzureManagedIdentityOAuthProvider;
import com.databricks.client.jdbc.oauth.ClientCredentialOAuthProvider;
import com.databricks.client.jdbc.oauth.OauthProvider;
import com.databricks.client.jdbc.oauth.TokenPassThroughOAuthProvider;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.databricks.client.spark.oauth.ClientCredential_JWT_OAuthProvider;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.exceptions.ErrorException;

public class SparkHS2OAuthClientWrapper
extends HS2OAuthClientWrapper {
    public SparkHS2OAuthClientWrapper(TProtocol tProtocol, ILogger iLogger, HiveJDBCSettings hiveJDBCSettings, TelemetryManager telemetryManager) throws ErrorException {
        super(tProtocol, iLogger, hiveJDBCSettings, telemetryManager);
    }

    @Override
    protected OauthProvider createOAuthProvider() throws ErrorException {
        switch (this.m_settings.m_oAuthSettings.m_authFlow) {
            case TOKEN_PASSTHROUGH: {
                return new TokenPassThroughOAuthProvider(this.m_settings, this.m_logger);
            }
            case CLIENT_CREDENTIALS: {
                if (this.m_settings.m_oAuthSettings.m_OAuthUseJWTAssertion.booleanValue()) {
                    return new ClientCredential_JWT_OAuthProvider(this.m_settings, this.m_logger);
                }
                return new ClientCredentialOAuthProvider(this.m_settings, this.m_logger);
            }
            case BROWSER: {
                return new AuthorizationCodeOAuthProvider(this.m_settings, this.m_logger);
            }
            case AZURE_Managed_Identity: {
                return new AzureManagedIdentityOAuthProvider(this.m_settings, this.m_logger);
            }
        }
        throw new ErrorException("08006", 105, CommonJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), new String[]{String.format("Auth_Flow %d is not valid,", new Object[]{this.m_settings.m_oAuthSettings.m_authFlow})});
    }
}

