/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector.compare;

import com.databricks.client.jdbc42.internal.apache.arrow.vector.BaseFixedWidthVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.Float4Vector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.Float8Vector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ValueVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.compare.Range;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.compare.RangeEqualsVisitor;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.compare.VectorValueEqualizer;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.compare.util.ValueEpsilonEqualizers;
import java.util.function.BiFunction;

public class ApproxEqualsVisitor
extends RangeEqualsVisitor {
    private final VectorValueEqualizer<Float4Vector> floatDiffFunction;
    private final VectorValueEqualizer<Float8Vector> doubleDiffFunction;
    public static final float DEFAULT_FLOAT_EPSILON = 1.0E-6f;
    public static final double DEFAULT_DOUBLE_EPSILON = 1.0E-6;

    public ApproxEqualsVisitor(ValueVector left, ValueVector right) {
        this(left, right, 1.0E-6f, 1.0E-6);
    }

    public ApproxEqualsVisitor(ValueVector left, ValueVector right, float floatEpsilon, double doubleEpsilon) {
        this(left, right, new ValueEpsilonEqualizers.Float4EpsilonEqualizer(floatEpsilon), new ValueEpsilonEqualizers.Float8EpsilonEqualizer(doubleEpsilon));
    }

    public ApproxEqualsVisitor(ValueVector left, ValueVector right, VectorValueEqualizer<Float4Vector> floatDiffFunction, VectorValueEqualizer<Float8Vector> doubleDiffFunction) {
        this(left, right, floatDiffFunction, doubleDiffFunction, DEFAULT_TYPE_COMPARATOR);
    }

    public ApproxEqualsVisitor(ValueVector left, ValueVector right, VectorValueEqualizer<Float4Vector> floatDiffFunction, VectorValueEqualizer<Float8Vector> doubleDiffFunction, BiFunction<ValueVector, ValueVector, Boolean> typeComparator) {
        super(left, right, typeComparator);
        this.floatDiffFunction = floatDiffFunction;
        this.doubleDiffFunction = doubleDiffFunction;
    }

    @Override
    public Boolean visit(BaseFixedWidthVector left, Range range) {
        if (left instanceof Float4Vector) {
            if (!this.validate(left)) {
                return false;
            }
            return this.float4ApproxEquals(range);
        }
        if (left instanceof Float8Vector) {
            if (!this.validate(left)) {
                return false;
            }
            return this.float8ApproxEquals(range);
        }
        return super.visit(left, range);
    }

    @Override
    protected ApproxEqualsVisitor createInnerVisitor(ValueVector left, ValueVector right, BiFunction<ValueVector, ValueVector, Boolean> typeComparator) {
        return new ApproxEqualsVisitor(left, right, this.floatDiffFunction.clone(), this.doubleDiffFunction.clone(), typeComparator);
    }

    private boolean float4ApproxEquals(Range range) {
        Float4Vector leftVector = (Float4Vector)this.getLeft();
        Float4Vector rightVector = (Float4Vector)this.getRight();
        for (int i = 0; i < range.getLength(); ++i) {
            int rightIndex;
            int leftIndex = range.getLeftStart() + i;
            if (this.floatDiffFunction.valuesEqual(leftVector, leftIndex, rightVector, rightIndex = range.getRightStart() + i)) continue;
            return false;
        }
        return true;
    }

    private boolean float8ApproxEquals(Range range) {
        Float8Vector leftVector = (Float8Vector)this.getLeft();
        Float8Vector rightVector = (Float8Vector)this.getRight();
        for (int i = 0; i < range.getLength(); ++i) {
            int rightIndex;
            int leftIndex = range.getLeftStart() + i;
            if (this.doubleDiffFunction.valuesEqual(leftVector, leftIndex, rightVector, rightIndex = range.getRightStart() + i)) continue;
            return false;
        }
        return true;
    }
}

