/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.exceptions;

import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.exceptions.JDBCMessageKey;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IMessageSource;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import com.databricks.client.support.exceptions.ExceptionType;
import com.databricks.client.support.exceptions.FailedPropertiesReason;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Map;

public abstract class ExceptionConverter {
    private static ExceptionConverter s_converter = null;

    protected ExceptionConverter() {
    }

    public static ExceptionConverter getInstance() {
        return s_converter;
    }

    public static void setInstance(ExceptionConverter exceptionConverter) {
        if (null != exceptionConverter) {
            s_converter = exceptionConverter;
        }
    }

    public abstract SQLException toSQLException(Exception var1, IWarningListener var2);

    public SQLException toSQLException(Exception exception, IWarningListener iWarningListener, ILogger iLogger) {
        SQLException sQLException = this.toSQLException(exception, iWarningListener);
        LogUtilities.logError(sQLException, iLogger);
        return sQLException;
    }

    public SQLException toSQLException(JDBCMessageKey jDBCMessageKey, IWarningListener iWarningListener, ExceptionType exceptionType, Object ... objectArray) {
        return this.toSQLException(jDBCMessageKey, iWarningListener, exceptionType, null, objectArray);
    }

    public SQLException createConversionException(ConversionFailed conversionFailed, String string, IWarningListener iWarningListener) {
        String string2;
        int n;
        String string3;
        Exception exception;
        IMessageSource iMessageSource = iWarningListener.getMessageSource();
        if (conversionFailed.getCause() instanceof ErrorException) {
            exception = (ErrorException)conversionFailed.getCause();
            string3 = iMessageSource.loadMessage(iWarningListener.getLocale(), 1, JDBCMessageKey.CONVERT_TO_ERR_WITH_CAUSE.name(), string, ((ErrorException)exception).getMessage(iMessageSource, iWarningListener.getLocale()));
            n = ((ErrorException)exception).getNativeErrorCode(iMessageSource, iWarningListener.getLocale());
            string2 = ((ErrorException)exception).hasCustomState() ? ((ErrorException)exception).getCustomState() : ((ErrorException)exception).getDiagState().getSqlState();
        } else {
            string3 = iMessageSource.loadMessage(iWarningListener.getLocale(), 1, JDBCMessageKey.CONVERT_TO_ERR.name(), string);
            n = ExceptionConverter.getNativeErrorCode(string3);
            string2 = JDBCMessageKey.CONVERT_TO_ERR.getSQLState();
        }
        exception = new SQLDataException(string3, string2, n, conversionFailed);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - 2];
        System.arraycopy(stackTraceElementArray, 2, stackTraceElementArray2, 0, stackTraceElementArray2.length);
        exception.setStackTrace(stackTraceElementArray2);
        return exception;
    }

    public SQLException toSQLException(JDBCMessageKey jDBCMessageKey, IWarningListener iWarningListener, ExceptionType exceptionType, Map<String, FailedPropertiesReason> map, Object ... objectArray) {
        IMessageSource iMessageSource = iWarningListener.getMessageSource();
        String string = iMessageSource.loadMessage(iWarningListener.getLocale(), 1, jDBCMessageKey.name(), objectArray);
        int n = ExceptionConverter.getNativeErrorCode(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - 2];
        System.arraycopy(stackTraceElementArray, 2, stackTraceElementArray2, 0, stackTraceElementArray2.length);
        return this.createSQLException(jDBCMessageKey.getSQLState(), string, n, stackTraceElementArray2, exceptionType, map);
    }

    public SQLException toSQLException(String string, String string2, int n, ExceptionType exceptionType) {
        return this.toSQLException(string, string2, n, exceptionType, null);
    }

    public SQLException toSQLException(String string, String string2, int n, ExceptionType exceptionType, Map<String, FailedPropertiesReason> map) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - 2];
        System.arraycopy(stackTraceElementArray, 2, stackTraceElementArray2, 0, stackTraceElementArray2.length);
        return this.createSQLException(string, string2, n, stackTraceElementArray2, exceptionType, map);
    }

    protected abstract SQLException createSQLException(String var1, String var2, int var3, StackTraceElement[] var4, ExceptionType var5, Map<String, FailedPropertiesReason> var6);

    private static int getNativeErrorCode(String string) {
        int n;
        int n2 = string.indexOf(40);
        if (n2 < (n = string.indexOf(41)) && -1 != n2) {
            String string2 = string.substring(++n2, n);
            try {
                return Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }
}

