/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.kv.CoreGetResult;
import com.couchbase.client.core.api.kv.CoreKvOps;
import com.couchbase.client.core.api.kv.CoreReadPreference;
import com.couchbase.client.core.api.kv.CoreSubdocGetResult;
import com.couchbase.client.core.api.kv.CoreSubdocMutateResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.kv.CoreScanOptions;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.kv.ReplicaHelper;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncBinaryCollection;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.kv.ExistsOptions;
import com.couchbase.client.java.kv.ExistsResult;
import com.couchbase.client.java.kv.Expiry;
import com.couchbase.client.java.kv.GetAllReplicasOptions;
import com.couchbase.client.java.kv.GetAndLockOptions;
import com.couchbase.client.java.kv.GetAndTouchOptions;
import com.couchbase.client.java.kv.GetAnyReplicaOptions;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetReplicaResult;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.LookupInAllReplicasOptions;
import com.couchbase.client.java.kv.LookupInAnyReplicaOptions;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInReplicaResult;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.ScanOptions;
import com.couchbase.client.java.kv.ScanResult;
import com.couchbase.client.java.kv.ScanType;
import com.couchbase.client.java.kv.TouchOptions;
import com.couchbase.client.java.kv.UnlockOptions;
import com.couchbase.client.java.kv.UpsertOptions;
import com.couchbase.client.java.manager.query.AsyncCollectionQueryIndexManager;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncCollection {
    private final CoreCouchbaseOps couchbaseOps;
    private final ClusterEnvironment environment;
    private final CoreKeyspace keyspace;
    private final AsyncBinaryCollection asyncBinaryCollection;
    final CoreKvOps kvOps;
    private final AsyncCollectionQueryIndexManager queryIndexManager;
    private final AsyncCluster cluster;

    AsyncCollection(CoreKeyspace keyspace, CoreCouchbaseOps couchbaseOps, ClusterEnvironment environment, AsyncCluster cluster) {
        this.keyspace = Objects.requireNonNull(keyspace);
        this.couchbaseOps = Objects.requireNonNull(couchbaseOps);
        this.environment = Objects.requireNonNull(environment);
        this.cluster = Objects.requireNonNull(cluster);
        this.asyncBinaryCollection = new AsyncBinaryCollection(keyspace, couchbaseOps, cluster);
        this.kvOps = couchbaseOps.kvOps(keyspace);
        this.queryIndexManager = new AsyncCollectionQueryIndexManager(couchbaseOps.queryOps(), couchbaseOps.coreResources().requestTracer(), keyspace);
    }

    @Stability.Volatile
    public Core core() {
        return this.couchbaseOps.asCore();
    }

    @Stability.Volatile
    public AsyncCollectionQueryIndexManager queryIndexes() {
        return this.queryIndexManager;
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    public String name() {
        return this.keyspace.collection();
    }

    public String bucketName() {
        return this.keyspace.bucket();
    }

    public String scopeName() {
        return this.keyspace.scope();
    }

    public AsyncBinaryCollection binary() {
        return this.asyncBinaryCollection;
    }

    public CompletableFuture<GetResult> get(String id) {
        return this.get(id, ReactiveCollection.DEFAULT_GET_OPTIONS);
    }

    public CompletableFuture<GetResult> get(String id, GetOptions options) {
        Validators.notNull((Object)options, (String)"GetOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        GetOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.getAsync((CoreCommonOptions)opts, id, opts.projections(), opts.withExpiry()).thenApply(coreGetResult -> new GetResult((CoreGetResult)coreGetResult, transcoder));
    }

    public CompletableFuture<GetResult> getAndLock(String id, Duration lockTime) {
        return this.getAndLock(id, lockTime, ReactiveCollection.DEFAULT_GET_AND_LOCK_OPTIONS);
    }

    public CompletableFuture<GetResult> getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        Validators.notNull((Object)options, (String)"GetAndLockOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        GetAndLockOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.getAndLockAsync((CoreCommonOptions)opts, id, lockTime).thenApply(coreGetResult -> new GetResult((CoreGetResult)coreGetResult, transcoder));
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Duration expiry) {
        return this.getAndTouch(id, expiry, ReactiveCollection.DEFAULT_GET_AND_TOUCH_OPTIONS);
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        return this.getAndTouch(id, Expiry.relative(expiry), options);
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Instant expiry) {
        return this.getAndTouch(id, expiry, ReactiveCollection.DEFAULT_GET_AND_TOUCH_OPTIONS);
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Instant expiry, GetAndTouchOptions options) {
        return this.getAndTouch(id, Expiry.absolute(expiry), options);
    }

    private CompletableFuture<GetResult> getAndTouch(String id, Expiry expiry, GetAndTouchOptions options) {
        Validators.notNull((Object)expiry, (String)"Expiry", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        Validators.notNull((Object)options, (String)"GetAndTouchOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        GetAndTouchOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.getAndTouchAsync((CoreCommonOptions)opts, id, expiry.encode()).thenApply(coreGetResult -> new GetResult((CoreGetResult)coreGetResult, transcoder));
    }

    public CompletableFuture<List<CompletableFuture<GetReplicaResult>>> getAllReplicas(String id) {
        return this.getAllReplicas(id, ReactiveCollection.DEFAULT_GET_ALL_REPLICAS_OPTIONS);
    }

    public CompletableFuture<List<CompletableFuture<GetReplicaResult>>> getAllReplicas(String id, GetAllReplicasOptions options) {
        Validators.notNull((Object)options, (String)"GetAllReplicasOptions");
        GetAllReplicasOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return ReplicaHelper.getAllReplicasAsync((Core)this.core(), (CollectionIdentifier)this.keyspace.toCollectionIdentifier(), (String)id, (Duration)opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), (RetryStrategy)opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), (RequestSpan)opts.parentSpan().orElse(null), (CoreReadPreference)opts.readPreference(), response -> GetReplicaResult.from(response, transcoder));
    }

    public CompletableFuture<GetReplicaResult> getAnyReplica(String id) {
        return this.getAnyReplica(id, ReactiveCollection.DEFAULT_GET_ANY_REPLICA_OPTIONS);
    }

    public CompletableFuture<GetReplicaResult> getAnyReplica(String id, GetAnyReplicaOptions options) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        Validators.notNull((Object)options, (String)"GetAnyReplicaOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        GetAnyReplicaOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return ReplicaHelper.getAnyReplicaAsync((Core)this.core(), (CollectionIdentifier)this.keyspace.toCollectionIdentifier(), (String)id, (Duration)opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), (RetryStrategy)opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), (RequestSpan)opts.parentSpan().orElse(null), (CoreReadPreference)opts.readPreference(), response -> GetReplicaResult.from(response, transcoder));
    }

    public CompletableFuture<ExistsResult> exists(String id) {
        return this.exists(id, ReactiveCollection.DEFAULT_EXISTS_OPTIONS);
    }

    public CompletableFuture<ExistsResult> exists(String id, ExistsOptions options) {
        ExistsOptions.Built opts = ((ExistsOptions)Validators.notNull((Object)options, (String)"options")).build();
        return this.kvOps.existsAsync((CoreCommonOptions)opts, id).toFuture().thenApply(ExistsResult::from);
    }

    public CompletableFuture<MutationResult> remove(String id) {
        return this.remove(id, ReactiveCollection.DEFAULT_REMOVE_OPTIONS);
    }

    public CompletableFuture<MutationResult> remove(String id, RemoveOptions options) {
        Validators.notNull((Object)options, (String)"RemoveOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        RemoveOptions.Built opts = options.build();
        return this.kvOps.removeAsync((CoreCommonOptions)opts, id, opts.cas(), opts.toCoreDurability()).toFuture().thenApply(MutationResult::new);
    }

    public CompletableFuture<MutationResult> insert(String id, Object content) {
        return this.insert(id, content, ReactiveCollection.DEFAULT_INSERT_OPTIONS);
    }

    public CompletableFuture<MutationResult> insert(String id, Object content, InsertOptions options) {
        Validators.notNull((Object)options, (String)"InsertOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        InsertOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.insertAsync((CoreCommonOptions)opts, id, () -> transcoder.encode(content), opts.toCoreDurability(), opts.expiry().encode()).toFuture().thenApply(MutationResult::new);
    }

    public CompletableFuture<MutationResult> upsert(String id, Object content) {
        return this.upsert(id, content, ReactiveCollection.DEFAULT_UPSERT_OPTIONS);
    }

    public CompletableFuture<MutationResult> upsert(String id, Object content, UpsertOptions options) {
        Validators.notNull((Object)options, (String)"UpsertOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        UpsertOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.upsertAsync((CoreCommonOptions)opts, id, () -> transcoder.encode(content), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry()).toFuture().thenApply(MutationResult::new);
    }

    public CompletableFuture<MutationResult> replace(String id, Object content) {
        return this.replace(id, content, ReactiveCollection.DEFAULT_REPLACE_OPTIONS);
    }

    public CompletableFuture<MutationResult> replace(String id, Object content, ReplaceOptions options) {
        Validators.notNull((Object)options, (String)"ReplaceOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        ReplaceOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.replaceAsync((CoreCommonOptions)opts, id, () -> transcoder.encode(content), opts.cas(), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry()).toFuture().thenApply(MutationResult::new);
    }

    public CompletableFuture<MutationResult> touch(String id, Duration expiry) {
        return this.touch(id, expiry, ReactiveCollection.DEFAULT_TOUCH_OPTIONS);
    }

    public CompletableFuture<MutationResult> touch(String id, Duration expiry, TouchOptions options) {
        return this.touch(id, Expiry.relative(expiry), options);
    }

    public CompletableFuture<MutationResult> touch(String id, Instant expiry) {
        return this.touch(id, expiry, ReactiveCollection.DEFAULT_TOUCH_OPTIONS);
    }

    public CompletableFuture<MutationResult> touch(String id, Instant expiry, TouchOptions options) {
        return this.touch(id, Expiry.absolute(expiry), options);
    }

    private CompletableFuture<MutationResult> touch(String id, Expiry expiry, TouchOptions options) {
        Validators.notNull((Object)options, (String)"TouchOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        Validators.notNull((Object)expiry, (String)"Expiry", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        TouchOptions.Built opts = options.build();
        return this.kvOps.touchAsync((CoreCommonOptions)opts, id, expiry.encode()).toFuture().thenApply(MutationResult::new);
    }

    public CompletableFuture<Void> unlock(String id, long cas) {
        return this.unlock(id, cas, ReactiveCollection.DEFAULT_UNLOCK_OPTIONS);
    }

    public CompletableFuture<Void> unlock(String id, long cas, UnlockOptions options) {
        Validators.notNull((Object)options, (String)"UnlockOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        UnlockOptions.Built opts = options.build();
        return this.kvOps.unlockAsync((CoreCommonOptions)opts, id, cas).toFuture();
    }

    public CompletableFuture<LookupInResult> lookupIn(String id, List<LookupInSpec> specs) {
        return this.lookupIn(id, specs, ReactiveCollection.DEFAULT_LOOKUP_IN_OPTIONS);
    }

    public CompletableFuture<LookupInResult> lookupIn(String id, List<LookupInSpec> specs, LookupInOptions options) {
        Validators.notNull((Object)options, (String)"LookupInOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        Validators.notNull(specs, (String)"LookupInSpecs", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        LookupInOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return this.kvOps.subdocGetAsync((CoreCommonOptions)opts, id, CbCollections.transform(specs, LookupInSpec::toCore), opts.accessDeleted()).thenApply(it -> new LookupInResult((CoreSubdocGetResult)it, serializer));
    }

    public CompletableFuture<List<CompletableFuture<LookupInReplicaResult>>> lookupInAllReplicas(String id, List<LookupInSpec> specs) {
        return this.lookupInAllReplicas(id, specs, ReactiveCollection.DEFAULT_LOOKUP_IN_ALL_REPLICA_OPTIONS);
    }

    public CompletableFuture<List<CompletableFuture<LookupInReplicaResult>>> lookupInAllReplicas(String id, List<LookupInSpec> specs, LookupInAllReplicasOptions options) {
        Validators.notNull((Object)options, (String)"LookupInAllReplicasOptions");
        LookupInAllReplicasOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return ReplicaHelper.lookupInAllReplicasAsync((Core)this.core(), (CollectionIdentifier)this.keyspace.toCollectionIdentifier(), (String)id, (List)CbCollections.transform(specs, LookupInSpec::toCore), (Duration)opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), (RetryStrategy)opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), (RequestSpan)opts.parentSpan().orElse(null), (CoreReadPreference)opts.readPreference(), response -> LookupInReplicaResult.from(response, serializer));
    }

    public CompletableFuture<LookupInReplicaResult> lookupInAnyReplica(String id, List<LookupInSpec> specs) {
        return this.lookupInAnyReplica(id, specs, ReactiveCollection.DEFAULT_LOOKUP_IN_ANY_REPLICA_OPTIONS);
    }

    public CompletableFuture<LookupInReplicaResult> lookupInAnyReplica(String id, List<LookupInSpec> specs, LookupInAnyReplicaOptions options) {
        Validators.notNullOrEmpty((String)id, (String)"Id", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        Validators.notNull((Object)options, (String)"LookupInAnyReplicaOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        LookupInAnyReplicaOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return ReplicaHelper.lookupInAnyReplicaAsync((Core)this.core(), (CollectionIdentifier)this.keyspace.toCollectionIdentifier(), (String)id, (List)CbCollections.transform(specs, LookupInSpec::toCore), (Duration)opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), (RetryStrategy)opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), (RequestSpan)opts.parentSpan().orElse(null), (CoreReadPreference)opts.readPreference(), response -> LookupInReplicaResult.from(response, serializer));
    }

    public CompletableFuture<MutateInResult> mutateIn(String id, List<MutateInSpec> specs) {
        return this.mutateIn(id, specs, ReactiveCollection.DEFAULT_MUTATE_IN_OPTIONS);
    }

    public CompletableFuture<MutateInResult> mutateIn(String id, List<MutateInSpec> specs, MutateInOptions options) {
        Validators.notNull((Object)options, (String)"MutateInOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        Validators.notNull(specs, (String)"MutationSpecs", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        MutateInOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        return this.kvOps.subdocMutateAsync((CoreCommonOptions)opts, id, () -> CbCollections.transform((Iterable)specs, it -> it.toCore(serializer)), opts.storeSemantics().toCore(), opts.cas(), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry(), opts.accessDeleted(), opts.createAsDeleted()).thenApply(it -> new MutateInResult((CoreSubdocMutateResult)it, serializer));
    }

    public CompletableFuture<List<ScanResult>> scan(ScanType scanType) {
        return this.scan(scanType, ScanOptions.scanOptions());
    }

    public CompletableFuture<List<ScanResult>> scan(ScanType scanType, ScanOptions options) {
        Validators.notNull((Object)scanType, (String)"ScanType", () -> ReducedKeyValueErrorContext.create(null, (CollectionIdentifier)this.collectionIdentifier()));
        ScanOptions.Built opts = ((ScanOptions)Validators.notNull((Object)options, (String)"ScanOptions", () -> ReducedKeyValueErrorContext.create(null, (CollectionIdentifier)this.collectionIdentifier()))).build();
        return this.kvOps.scanRequestReactive(scanType.build(), (CoreScanOptions)opts).map(r -> new ScanResult(opts.idsOnly(), r.key(), r.value(), r.flags(), r.cas(), Optional.ofNullable(r.expiry()), opts.transcoder() != null ? opts.transcoder() : this.environment().transcoder())).collectList().toFuture();
    }

    CollectionIdentifier collectionIdentifier() {
        return this.keyspace.toCollectionIdentifier();
    }
}

