/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.internal;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.java.codec.JsonSerializer;

@Stability.Internal
public class EncodingUtil {
    private EncodingUtil() {
    }

    public static byte[] encode(Object content, RequestSpan span, JsonSerializer serializer, CoreContext coreContext) {
        byte[] encoded;
        RequestSpan encoding = CbTracing.newSpan((CoreContext)coreContext, (String)"request_encoding", (RequestSpan)span);
        try {
            encoded = serializer.serialize(content);
            encoding.end();
        }
        catch (Throwable err) {
            encoding.recordException(err);
            encoding.status(RequestSpan.StatusCode.ERROR);
            throw err;
        }
        return encoded;
    }
}

