/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreHighlightStyle;
import com.couchbase.client.core.api.search.CoreSearchKeyset;
import com.couchbase.client.core.api.search.CoreSearchOptions;
import com.couchbase.client.core.api.search.CoreSearchScanConsistency;
import com.couchbase.client.core.api.search.facet.CoreSearchFacet;
import com.couchbase.client.core.api.search.sort.CoreSearchSort;
import com.couchbase.client.core.api.search.sort.CoreSearchSortString;
import com.couchbase.client.core.api.shared.CoreMutationState;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.kv.MutationState;
import com.couchbase.client.java.query.QueryOptionsUtil;
import com.couchbase.client.java.search.HighlightStyle;
import com.couchbase.client.java.search.SearchScanConsistency;
import com.couchbase.client.java.search.facet.SearchFacet;
import com.couchbase.client.java.search.result.SearchKeyset;
import com.couchbase.client.java.search.sort.SearchSort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class SearchOptions
extends CommonOptions<SearchOptions> {
    @Nullable
    private List<String> collections;
    private SearchScanConsistency consistency;
    private MutationState consistentWith;
    private boolean disableScoring = false;
    private Boolean explain;
    private Map<String, SearchFacet> facets;
    @Nullable
    private List<String> fields;
    @Nullable
    private List<String> highlightFields;
    private HighlightStyle highlightStyle;
    private Integer limit;
    private Map<String, Object> raw;
    private JsonSerializer serializer;
    private Integer skip;
    @Nullable
    private List<CoreSearchSort> sort;
    private Boolean includeLocations;
    @Nullable
    private SearchKeyset searchBefore;
    @Nullable
    private SearchKeyset searchAfter;

    public static SearchOptions searchOptions() {
        return new SearchOptions();
    }

    private SearchOptions() {
    }

    public SearchOptions raw(String key, Object value) {
        Validators.notNullOrEmpty((String)key, (String)"Key");
        if (this.raw == null) {
            this.raw = new HashMap<String, Object>();
        }
        this.raw.put(key, value);
        return this;
    }

    public SearchOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public SearchOptions skip(int skip) {
        this.skip = skip;
        this.searchAfter = null;
        this.searchBefore = null;
        return this;
    }

    public SearchOptions explain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public SearchOptions highlight(HighlightStyle style, String ... fields) {
        this.highlightStyle = style;
        this.highlightFields = new ArrayList<String>(Arrays.asList(Objects.requireNonNull(fields)));
        return this;
    }

    public SearchOptions highlight(String ... fields) {
        return this.highlight(HighlightStyle.SERVER_DEFAULT, fields);
    }

    public SearchOptions highlight() {
        return this.highlight(HighlightStyle.SERVER_DEFAULT, new String[0]);
    }

    public SearchOptions fields(String ... fields) {
        this.fields = new ArrayList<String>(Arrays.asList(Objects.requireNonNull(fields)));
        return this;
    }

    public SearchOptions collections(String ... collectionNames) {
        this.collections = new ArrayList<String>(Arrays.asList(Objects.requireNonNull(collectionNames)));
        return this;
    }

    public SearchOptions scanConsistency(SearchScanConsistency consistency) {
        this.consistency = consistency;
        this.consistentWith = null;
        return this;
    }

    public SearchOptions consistentWith(MutationState consistentWith) {
        this.consistentWith = consistentWith;
        this.consistency = null;
        return this;
    }

    public SearchOptions sort(Object ... sort) {
        if (sort != null) {
            for (Object o : sort) {
                if (this.sort == null) {
                    this.sort = new ArrayList<CoreSearchSort>();
                }
                if (o instanceof String) {
                    this.sort.add((CoreSearchSort)new CoreSearchSortString((String)o));
                    continue;
                }
                if (o instanceof SearchSort) {
                    this.sort.add(((SearchSort)o).toCore());
                    continue;
                }
                throw InvalidArgumentException.fromMessage((String)"Only String or SearchSort instances are allowed as sort arguments!");
            }
        }
        return this;
    }

    public SearchOptions facets(Map<String, SearchFacet> facets) {
        this.facets = facets;
        return this;
    }

    public SearchOptions serializer(JsonSerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public SearchOptions disableScoring(boolean disableScoring) {
        this.disableScoring = disableScoring;
        return this;
    }

    public SearchOptions includeLocations(boolean includeLocations) {
        this.includeLocations = includeLocations;
        return this;
    }

    @Stability.Volatile
    public SearchOptions searchBefore(SearchKeyset searchBefore) {
        this.searchBefore = searchBefore;
        this.searchAfter = null;
        this.skip = null;
        return this;
    }

    @Stability.Volatile
    public SearchOptions searchAfter(SearchKeyset searchAfter) {
        this.searchAfter = searchAfter;
        this.searchBefore = null;
        this.skip = null;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions
    implements CoreSearchOptions {
        Built() {
            super(SearchOptions.this);
        }

        public JsonSerializer serializer() {
            return SearchOptions.this.serializer;
        }

        public List<String> collections() {
            return SearchOptions.this.collections == null ? Collections.emptyList() : SearchOptions.this.collections;
        }

        public CoreSearchScanConsistency consistency() {
            if (SearchOptions.this.consistency == SearchScanConsistency.NOT_BOUNDED) {
                return CoreSearchScanConsistency.NOT_BOUNDED;
            }
            return null;
        }

        public CoreMutationState consistentWith() {
            if (SearchOptions.this.consistentWith == null) {
                return null;
            }
            return new CoreMutationState((Iterable)SearchOptions.this.consistentWith);
        }

        public Boolean disableScoring() {
            return SearchOptions.this.disableScoring;
        }

        public Boolean explain() {
            return SearchOptions.this.explain;
        }

        public Map<String, CoreSearchFacet> facets() {
            if (SearchOptions.this.facets == null) {
                return Collections.emptyMap();
            }
            HashMap<String, CoreSearchFacet> out = new HashMap<String, CoreSearchFacet>();
            SearchOptions.this.facets.forEach((k, v) -> out.put((String)k, v.toCore()));
            return out;
        }

        public List<String> fields() {
            return SearchOptions.this.fields == null ? Collections.emptyList() : SearchOptions.this.fields;
        }

        public List<String> highlightFields() {
            return SearchOptions.this.highlightFields == null ? Collections.emptyList() : SearchOptions.this.highlightFields;
        }

        public CoreHighlightStyle highlightStyle() {
            if (SearchOptions.this.highlightStyle == null) {
                return null;
            }
            switch (SearchOptions.this.highlightStyle) {
                case HTML: {
                    return CoreHighlightStyle.HTML;
                }
                case ANSI: {
                    return CoreHighlightStyle.ANSI;
                }
                case SERVER_DEFAULT: {
                    return CoreHighlightStyle.SERVER_DEFAULT;
                }
            }
            throw new IllegalStateException("Internal bug - unknown highlight style");
        }

        public Integer limit() {
            return SearchOptions.this.limit;
        }

        public JsonNode raw() {
            if (SearchOptions.this.raw == null) {
                return null;
            }
            return QueryOptionsUtil.convert(SearchOptions.this.raw);
        }

        public Integer skip() {
            return SearchOptions.this.skip;
        }

        public List<CoreSearchSort> sort() {
            return SearchOptions.this.sort == null ? Collections.emptyList() : SearchOptions.this.sort;
        }

        public Boolean includeLocations() {
            return SearchOptions.this.includeLocations;
        }

        public CoreCommonOptions commonOptions() {
            return this;
        }

        @Nullable
        public CoreSearchKeyset searchBefore() {
            return SearchOptions.this.searchBefore == null ? null : SearchOptions.this.searchBefore.toCore();
        }

        @Nullable
        public CoreSearchKeyset searchAfter() {
            return SearchOptions.this.searchAfter == null ? null : SearchOptions.this.searchAfter.toCore();
        }
    }
}

