/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.user;

import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.manager.user.AsyncUserManager;
import com.couchbase.client.java.manager.user.AuthDomain;
import com.couchbase.client.java.manager.user.ChangePasswordOptions;
import com.couchbase.client.java.manager.user.DropGroupOptions;
import com.couchbase.client.java.manager.user.DropUserOptions;
import com.couchbase.client.java.manager.user.GetAllGroupsOptions;
import com.couchbase.client.java.manager.user.GetAllUsersOptions;
import com.couchbase.client.java.manager.user.GetGroupOptions;
import com.couchbase.client.java.manager.user.GetRolesOptions;
import com.couchbase.client.java.manager.user.GetUserOptions;
import com.couchbase.client.java.manager.user.Group;
import com.couchbase.client.java.manager.user.ReactiveUserManager;
import com.couchbase.client.java.manager.user.RoleAndDescription;
import com.couchbase.client.java.manager.user.UpsertGroupOptions;
import com.couchbase.client.java.manager.user.UpsertUserOptions;
import com.couchbase.client.java.manager.user.User;
import com.couchbase.client.java.manager.user.UserAndMetadata;
import java.util.List;
import java.util.Objects;

public class UserManager {
    private final AsyncUserManager async;
    private final ReactorOps reactor;

    public UserManager(ReactorOps reactor, AsyncUserManager async) {
        this.reactor = Objects.requireNonNull(reactor);
        this.async = Objects.requireNonNull(async);
    }

    public AsyncUserManager async() {
        return this.async;
    }

    public ReactiveUserManager reactive() {
        return new ReactiveUserManager(this.reactor, this.async);
    }

    public UserAndMetadata getUser(AuthDomain domain, String username) {
        return AsyncUtils.block(this.async.getUser(domain, username));
    }

    public UserAndMetadata getUser(AuthDomain domain, String username, GetUserOptions options) {
        return AsyncUtils.block(this.async.getUser(domain, username, options));
    }

    public List<RoleAndDescription> getRoles() {
        return AsyncUtils.block(this.async.getRoles());
    }

    public List<RoleAndDescription> getRoles(GetRolesOptions options) {
        return AsyncUtils.block(this.async.getRoles(options));
    }

    public void changePassword(String newPassword, ChangePasswordOptions options) {
        AsyncUtils.block(this.async.changePassword(newPassword, options));
    }

    public void changePassword(String newPassword) {
        AsyncUtils.block(this.async.changePassword(newPassword));
    }

    public List<UserAndMetadata> getAllUsers() {
        return AsyncUtils.block(this.async.getAllUsers());
    }

    public List<UserAndMetadata> getAllUsers(GetAllUsersOptions options) {
        return AsyncUtils.block(this.async.getAllUsers(options));
    }

    public void upsertUser(User user) {
        AsyncUtils.block(this.async.upsertUser(user));
    }

    public void upsertUser(User user, UpsertUserOptions options) {
        AsyncUtils.block(this.async.upsertUser(user, options));
    }

    public void dropUser(String username) {
        AsyncUtils.block(this.async.dropUser(username));
    }

    public void dropUser(String username, DropUserOptions options) {
        AsyncUtils.block(this.async.dropUser(username, options));
    }

    public Group getGroup(String name) {
        return AsyncUtils.block(this.async.getGroup(name));
    }

    public Group getGroup(String name, GetGroupOptions options) {
        return AsyncUtils.block(this.async.getGroup(name, options));
    }

    public List<Group> getAllGroups() {
        return AsyncUtils.block(this.async.getAllGroups());
    }

    public List<Group> getAllGroups(GetAllGroupsOptions options) {
        return AsyncUtils.block(this.async.getAllGroups(options));
    }

    public void upsertGroup(Group group) {
        AsyncUtils.block(this.async.upsertGroup(group));
    }

    public void upsertGroup(Group group, UpsertGroupOptions options) {
        AsyncUtils.block(this.async.upsertGroup(group, options));
    }

    public void dropGroup(String name) {
        AsyncUtils.block(this.async.dropGroup(name));
    }

    public void dropGroup(String name, DropGroupOptions options) {
        AsyncUtils.block(this.async.dropGroup(name, options));
    }
}

