/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.java.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.java.manager.query.BuildQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreateQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropPrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropQueryIndexOptions;
import com.couchbase.client.java.manager.query.GetAllQueryIndexesOptions;
import com.couchbase.client.java.manager.query.QueryIndex;
import com.couchbase.client.java.manager.query.WatchQueryIndexesOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveQueryIndexManager {
    private final AsyncQueryIndexManager async;
    private final ReactorOps reactor;

    @Stability.Internal
    public ReactiveQueryIndexManager(ReactorOps reactor, AsyncQueryIndexManager async) {
        this.reactor = Objects.requireNonNull(reactor);
        this.async = Objects.requireNonNull(async);
    }

    public AsyncQueryIndexManager async() {
        return this.async;
    }

    public Mono<Void> createIndex(String bucketName, String indexName, Collection<String> fields) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createIndex(bucketName, indexName, fields));
    }

    public Mono<Void> createIndex(String bucketName, String indexName, Collection<String> fields, CreateQueryIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createIndex(bucketName, indexName, fields, options));
    }

    public Mono<Void> createPrimaryIndex(String bucketName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createPrimaryIndex(bucketName));
    }

    public Mono<Void> createPrimaryIndex(String bucketName, CreatePrimaryQueryIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createPrimaryIndex(bucketName, options));
    }

    public Flux<QueryIndex> getAllIndexes(String bucketName) {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.async.getAllIndexes(bucketName)));
    }

    public Flux<QueryIndex> getAllIndexes(String bucketName, GetAllQueryIndexesOptions options) {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.async.getAllIndexes(bucketName, options)));
    }

    public Mono<Void> dropPrimaryIndex(String bucketName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropPrimaryIndex(bucketName));
    }

    public Mono<Void> dropPrimaryIndex(String bucketName, DropPrimaryQueryIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropPrimaryIndex(bucketName, options));
    }

    public Mono<Void> dropIndex(String bucketName, String indexName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropIndex(bucketName, indexName));
    }

    public Mono<Void> dropIndex(String bucketName, String indexName, DropQueryIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropIndex(bucketName, indexName, options));
    }

    public Mono<Void> buildDeferredIndexes(String bucketName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.buildDeferredIndexes(bucketName));
    }

    public Mono<Void> buildDeferredIndexes(String bucketName, BuildQueryIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.buildDeferredIndexes(bucketName, options));
    }

    public Mono<Void> watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout) {
        return this.reactor.publishOnUserScheduler(() -> this.async.watchIndexes(bucketName, indexNames, timeout));
    }

    public Mono<Void> watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout, WatchQueryIndexesOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.watchIndexes(bucketName, indexNames, timeout, options));
    }
}

