/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.encryption.databind.jackson.repackaged;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonGenerator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonSerializer;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.SerializerProvider;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.java.encryption.annotation.Encrypted;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;

@Stability.Internal
public class EncryptedFieldSerializer
extends StdSerializer<Object> {
    private final CryptoManager cryptoManager;
    private final Encrypted annotation;
    private final JsonSerializer<Object> originalCustomSerializer;

    public EncryptedFieldSerializer(CryptoManager cryptoManager, Encrypted annotation, JsonSerializer<Object> originalCustomSerializer) {
        super(Object.class);
        this.cryptoManager = Objects.requireNonNull(cryptoManager);
        this.annotation = Objects.requireNonNull(annotation);
        this.originalCustomSerializer = originalCustomSerializer;
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        byte[] plaintextJson = this.serializePlaintext(value, gen, provider);
        Map encrypted = this.cryptoManager.encrypt(plaintextJson, this.annotation.encrypter());
        gen.writeObject((Object)encrypted);
    }

    private byte[] serializePlaintext(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JsonGenerator plaintextGenerator = gen.getCodec().getFactory().createGenerator((OutputStream)out);){
            if (this.originalCustomSerializer != null) {
                this.originalCustomSerializer.serialize(value, plaintextGenerator, provider);
            } else {
                provider.defaultSerializeValue(value, plaintextGenerator);
            }
        }
        return out.toByteArray();
    }
}

