/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.cluster;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.util.features.CouchbaseFeature;
import com.couchbase.client.java.util.features.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultClusterInfo
implements ClusterInfo {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DefaultClusterInfo.class);
    private final JsonObject raw;

    public DefaultClusterInfo(JsonObject raw) {
        this.raw = raw;
    }

    @Override
    public JsonObject raw() {
        return this.raw;
    }

    @Override
    public boolean checkAvailable(CouchbaseFeature feature) {
        Version minVersion = this.getMinVersion();
        return feature.isAvailableOn(minVersion);
    }

    @Override
    public Version getMinVersion() {
        List<Version> versions = this.getAllVersions();
        if (versions.isEmpty()) {
            return Version.NO_VERSION;
        }
        if (versions.size() == 1) {
            return versions.get(0);
        }
        Version minVersion = versions.get(0);
        for (Version version : versions) {
            if (version.compareTo(minVersion) >= 0) continue;
            minVersion = version;
        }
        return minVersion;
    }

    @Override
    public List<Version> getAllVersions() {
        try {
            JsonObject raw = this.raw();
            if (!raw.containsKey("nodes")) {
                return Collections.emptyList();
            }
            ArrayList<Version> result = new ArrayList<Version>();
            JsonArray nodes = raw.getArray("nodes");
            for (int i = 0; i < nodes.size(); ++i) {
                JsonObject node = nodes.getObject(i);
                if (!node.containsKey("version")) continue;
                String versionFull = node.getString("version");
                Version version = Version.parseVersion(versionFull);
                result.add(version);
            }
            return result;
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Could not obtain cluster list of versions", (Throwable)e);
            }
            return Collections.emptyList();
        }
    }
}

