/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document.json;

import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonObject
extends JsonValue
implements Serializable {
    private static final long serialVersionUID = 8817717605659870262L;
    private final Map<String, Object> content;

    private JsonObject() {
        this.content = new HashMap<String, Object>();
    }

    private JsonObject(int initialCapacity) {
        this.content = new HashMap<String, Object>(initialCapacity);
    }

    public static JsonObject empty() {
        return new JsonObject();
    }

    public static JsonObject create() {
        return new JsonObject();
    }

    public static JsonObject from(Map<String, ?> mapData) {
        if (mapData == null) {
            throw new NullPointerException("Null input Map unsupported");
        }
        if (mapData.isEmpty()) {
            return JsonObject.empty();
        }
        JsonObject result = new JsonObject(mapData.size());
        for (Map.Entry<String, ?> entry : mapData.entrySet()) {
            JsonValue sub;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == JsonValue.NULL) {
                value = null;
            }
            if (key == null) {
                throw new NullPointerException("The key is not allowed to be null");
            }
            if (value instanceof Map) {
                try {
                    sub = JsonObject.from((Map)value);
                    result.put(key, (JsonObject)sub);
                    continue;
                }
                catch (ClassCastException e) {
                    throw e;
                }
                catch (Exception e) {
                    ClassCastException c = new ClassCastException("Couldn't convert sub-Map " + key + " to JsonObject");
                    c.initCause(e);
                    throw c;
                }
            }
            if (value instanceof List) {
                try {
                    sub = JsonArray.from((List)value);
                    result.put(key, (JsonArray)sub);
                    continue;
                }
                catch (Exception e) {
                    ClassCastException c = new ClassCastException("Couldn't convert sub-List " + key + " to JsonArray");
                    c.initCause(e);
                    throw c;
                }
            }
            if (!JsonObject.checkType(value)) {
                throw new IllegalArgumentException("Unsupported type for JsonObject: " + value.getClass());
            }
            result.put(key, value);
        }
        return result;
    }

    public static JsonObject fromJson(String s) {
        try {
            return CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.stringToJsonObject(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert string to JsonObject", e);
        }
    }

    public JsonObject put(String name, Object value) {
        if (this == value) {
            throw new IllegalArgumentException("Cannot put self");
        }
        if (value == JsonValue.NULL) {
            this.putNull(name);
        } else if (JsonObject.checkType(value)) {
            this.content.put(name, value);
        } else {
            throw new IllegalArgumentException("Unsupported type for JsonObject: " + value.getClass());
        }
        return this;
    }

    public Object get(String name) {
        return this.content.get(name);
    }

    public JsonObject put(String name, String value) {
        this.content.put(name, value);
        return this;
    }

    public String getString(String name) {
        return (String)this.content.get(name);
    }

    public JsonObject put(String name, int value) {
        this.content.put(name, value);
        return this;
    }

    public Integer getInt(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    public JsonObject put(String name, long value) {
        this.content.put(name, value);
        return this;
    }

    public Long getLong(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return number.longValue();
    }

    public JsonObject put(String name, double value) {
        this.content.put(name, value);
        return this;
    }

    public Double getDouble(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public JsonObject put(String name, boolean value) {
        this.content.put(name, value);
        return this;
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.content.get(name);
    }

    public JsonObject put(String name, JsonObject value) {
        if (this == value) {
            throw new IllegalArgumentException("Cannot put self");
        }
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, Map<String, ?> value) {
        return this.put(name, JsonObject.from(value));
    }

    public JsonObject getObject(String name) {
        return (JsonObject)this.content.get(name);
    }

    public JsonObject put(String name, JsonArray value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, Number value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, List<?> value) {
        return this.put(name, JsonArray.from(value));
    }

    public JsonArray getArray(String name) {
        return (JsonArray)this.content.get(name);
    }

    public BigInteger getBigInteger(String name) {
        return (BigInteger)this.content.get(name);
    }

    public BigDecimal getBigDecimal(String name) {
        Object found = this.content.get(name);
        if (found == null) {
            return null;
        }
        if (found instanceof Double) {
            return new BigDecimal((Double)found);
        }
        return (BigDecimal)found;
    }

    public Number getNumber(String name) {
        return (Number)this.content.get(name);
    }

    public JsonObject putNull(String name) {
        this.content.put(name, null);
        return this;
    }

    public JsonObject removeKey(String name) {
        this.content.remove(name);
        return this;
    }

    public Set<String> getNames() {
        return this.content.keySet();
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.content.size());
        for (Map.Entry<String, Object> entry : this.content.entrySet()) {
            Object content = entry.getValue();
            if (content instanceof JsonObject) {
                copy.put(entry.getKey(), ((JsonObject)content).toMap());
                continue;
            }
            if (content instanceof JsonArray) {
                copy.put(entry.getKey(), ((JsonArray)content).toList());
                continue;
            }
            copy.put(entry.getKey(), content);
        }
        return copy;
    }

    public boolean containsKey(String name) {
        return this.content.containsKey(name);
    }

    public boolean containsValue(Object value) {
        return this.content.containsValue(value);
    }

    public int size() {
        return this.content.size();
    }

    public String toString() {
        try {
            return JacksonTransformers.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot convert JsonObject to Json String", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonObject object = (JsonObject)o;
        return !(this.content != null ? !this.content.equals(object.content) : object.content != null);
    }

    public int hashCode() {
        return this.content.hashCode();
    }
}

